% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{rs_replace_table}
\alias{rs_replace_table}
\title{Replace redshift table}
\usage{
rs_replace_table(df, dbcon, table_name, split_files,
  bucket = Sys.getenv("AWS_BUCKET_NAME"),
  region = Sys.getenv("AWS_DEFAULT_REGION"),
  access_key = Sys.getenv("AWS_ACCESS_KEY_ID"),
  secret_key = Sys.getenv("AWS_SECRET_ACCESS_KEY"),
  session_token = Sys.getenv("AWS_SESSION_TOKEN"),
  iam_role_arn = Sys.getenv("AWS_IAM_ROLE_ARN"), wlm_slots = 1,
  additional_params = "")
}
\arguments{
\item{df}{a data frame}

\item{dbcon}{an RPostgres/RJDBC connection to the redshift server}

\item{table_name}{the name of the table to replace}

\item{split_files}{optional parameter to specify amount of files to split into. If not specified will look at amount of slices in Redshift to determine an optimal amount.}

\item{bucket}{the name of the temporary bucket to load the data. Will look for AWS_BUCKET_NAME on environment if not specified.}

\item{region}{the region of the bucket. Will look for AWS_DEFAULT_REGION on environment if not specified.}

\item{access_key}{the access key with permissions for the bucket. Will look for AWS_ACCESS_KEY_ID on environment if not specified.}

\item{secret_key}{the secret key with permissions fot the bucket. Will look for AWS_SECRET_ACCESS_KEY on environment if not specified.}

\item{session_token}{the session key with permissions for the bucket, this will be used instead of the access/secret keys if specified. Will look for AWS_SESSION_TOKEN on environment if not specified.}

\item{iam_role_arn}{an iam role arn with permissions fot the bucket. Will look for AWS_IAM_ROLE_ARN on environment if not specified. This is ignoring access_key and secret_key if set.}

\item{wlm_slots}{amount of WLM slots to use for this bulk load http://docs.aws.amazon.com/redshift/latest/dg/tutorial-configuring-workload-management.html}

\item{additional_params}{Additional params to send to the COPY statement in Redshift}
}
\description{
Upload a table to S3 and then load it with redshift, replacing the contents of that table.
The table on redshift has to have the same structure and column ordering to work correctly.
}
\examples{
library(DBI)

a=data.frame(a=seq(1,10000), b=seq(10000,1))

\dontrun{
con <- dbConnect(RPostgres::Postgres(), dbname="dbname",
host='my-redshift-url.amazon.com', port='5439',
user='myuser', password='mypassword',sslmode='require')

rs_replace_table(df=a, dbcon=con, table_name='testTable',
bucket="my-bucket", split_files=4)

}
}
