% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridUncertainty_functions.R
\name{gridUncertainty}
\alias{gridUncertainty}
\title{Function to compute AOO with grid uncertainty systematically with stopping rule}
\usage{
gridUncertainty(input.data, grid.size, n.AOO.improvement,
  min.percent.rule = FALSE, percent = 1)
}
\arguments{
\item{input.data}{Object of an ecosystem or species distribution. Accepts either
raster or spatial points formats. Please use a CRS with units measured in
metres.}

\item{grid.size}{A number specifying the width of the desired grid square (in
same units as your coordinate reference system)}

\item{n.AOO.improvement}{Specifies the minimum number of rounds the
calculated AOO is not improved before stopping the function.}

\item{min.percent.rule}{Logical. If \code{TRUE}, a minimum area threshold
must be passed before a grid is counted as an AOO grid.}

\item{percent}{Numeric. The minimum percent to be applied as a threshold for
the \code{min.percent.rule}.}
}
\value{
A list containing the following:
\itemize{
 \item Data frame of results showing the minimum AOO calculated for each
 shift scenario
 \item Single SpatialPolygonsDataFrame containing the AOO grid which would
 produce the minimum AOO calculated
}
}
\description{
\code{gridUncertainty} determines the number of area of occupancy (AOO) grid
cells occupied by a species or ecosystem systematically. It will only stop
when the AOO calculated does not improve (decrease) after a set number of
split scenarios.
}
\examples{
crs.UTM55S <- '+proj=utm +zone=55 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs'
r1 <- raster(ifelse((volcano<130), NA, 1), crs = crs.UTM55S)
extent(r1) <- extent(0, 6100, 0, 8700)
x <- gridUncertainty(r1, grid.size = 10000, n.AOO.improvement = 5,
                           min.percent.rule = FALSE, percent = 1)
}
\seealso{
Other gridUncertainty functions: \code{\link{gridUncertaintyBase}},
  \code{\link{gridUncertaintyRandomManual}},
  \code{\link{gridUncertaintyRandom}},
  \code{\link{gridUncertaintyRestricted}},
  \code{\link{gridUncertaintySimulation}}
}
\author{
Calvin Lee \email{calvinkflee@gmail.com}
}
\concept{gridUncertainty functions}
