% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AOO_functions.R
\name{createGrid}
\alias{createGrid}
\title{Create empty Area of Occupancy (AOO) Grid.}
\usage{
createGrid(input.data, grid.size)
}
\arguments{
\item{input.data}{Object of an ecosystem or species distribution. Accepts either
raster or spatial points formats. Please use a CRS with units measured in
metres.}

\item{grid.size}{A number specifying the width of the desired grid square (in
same units as your coordinate reference system)}
}
\value{
A regular grid raster with extent \code{input.data} and grid size
  \code{grid.size}. Each grid square has a unique identification number.
}
\description{
\code{createGrid} produces empty grid which can be used as the basis to help
compute AOO.
}
\references{
Bland, L.M., Keith, D.A., Miller, R.M., Murray, N.J. and
  Rodriguez, J.P. (eds.) 2016. Guidelines for the application of IUCN Red
  List of Ecosystems Categories and Criteria, Version 1.0. Gland,
  Switzerland: IUCN. ix + 94pp. Available at the following web site:
  \url{https://iucnrle.org/}
}
\seealso{
Other AOO functions: \code{\link{getAOOSilent}},
  \code{\link{getAOO}}, \code{\link{makeAOOGrid}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
