% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R, R/metrics.R
\name{partisan_metrics}
\alias{partisan_metrics}
\alias{redist.metrics}
\title{Calculate gerrymandering metrics for a set of plans}
\usage{
partisan_metrics(map, measure, rvote, dvote, ..., .data = cur_plans())

redist.metrics(
  plans,
  measure = "DSeats",
  rvote,
  dvote,
  tau = 1,
  biasV = 0.5,
  respV = 0.5,
  bandwidth = 0.01,
  draw = 1
)
}
\arguments{
\item{map}{a \code{\link{redist_map}} object}

\item{measure}{A vector with a string for each measure desired from list "DSeats", "DVS", "EffGap",
"EffGapEqPop", "TauGap", "MeanMedian", "Bias", "BiasV", "Declination",
"Responsiveness", "LopsidedWins", "RankedMarginal", and "SmoothedSeat". Use "all" to get all metrics.
"DSeats" and "DVS" are always computed, so it is recommended to always return those values.}

\item{rvote}{A numeric vector with the Republican vote for each precinct.}

\item{dvote}{A numeric vector with the Democratic vote for each precinct.}

\item{...}{passed on to \code{redist.metrics}}

\item{.data}{a \code{\link{redist_plans}} object}

\item{plans}{A numeric vector (if only one map) or matrix with one row
for each precinct and one column for each map. Required.}

\item{tau}{A non-negative number for calculating Tau Gap. Only used with option "TauGap". Defaults to 1.}

\item{biasV}{A value between 0 and 1 to compute bias at. Only used with option "BiasV". Defaults to 0.5.}

\item{respV}{A value between 0 and 1 to compute responsiveness at. Only used with option "Responsiveness". Defaults to 0.5.}

\item{bandwidth}{A value between 0 and 1 for computing responsiveness. Only used with option "Responsiveness." Defaults to 0.01.}

\item{draw}{A numeric to specify draw number. Defaults to 1 if only one map provided
and the column number if multiple maps given. Can also take a factor input, which will become the
draw column in the output if its length matches the number of entries in plans. If the \code{plans} input
is a \code{redist_plans} object, it extracts the \code{draw} identifier.}
}
\value{
A tibble with  a column for each specified measure and
a column that specifies the map number.
}
\description{
\code{redist.metrics} is used to compute different gerrymandering metrics for a
set of maps.
}
\details{
This function computes specified compactness scores for a map.  If
there is more than one precinct specified for a map, it aggregates to the district level
and computes one score.
\itemize{
\item DSeats is computed as the expected number of Democratic seats with no change in votes.
\item DVS is the Democratic Vote Share, which is the two party vote share with Democratic votes as the numerator.
\item EffGap is the Efficiency Gap, calculated with votes directly.
\item EffGapEqPop is the Efficiency Gap under an Equal Population assumption, calculated with the DVS.
\item TauGap is the Tau Gap, computed with the Equal Population assumption.
\item MeanMedian is the Mean Median difference.
\item Bias is the Partisan Bias computed at 0.5.
\item BiasV is the Partisan Bias computed at value V.
\item Declination is the value of declination at 0.5.
\item Responsiveness is the responsiveness at the user-supplied value with the user-supplied bandwidth.
\item LopsidedWins computed the Lopsided Outcomes value, but does not produce a test statistic.
\item RankedMarginal computes the Ranked Marginal Deviation (0-1, smaller is better). This is also known
as the "Gerrymandering Index" and is sometimes presented as this value divided by 10000.
\item SmoothedSeat computes the Smoothed Seat Count Deviation (0-1, smaller is R Bias, bigger is D Bias).
}
}
\examples{
data(fl25)
data(fl25_enum)
plans_05 <- fl25_enum$plans[, fl25_enum$pop_dev <= 0.05]
redist.metrics(plans_05, measure = "all", rvote = fl25$mccain, dvote = fl25$obama)

}
\references{
Jonathan N. Katz, Gary King, and Elizabeth Rosenblatt. 2020.
Theoretical Foundations and Empirical Evaluations of Partisan Fairness in District-Based Democracies.
American Political Science Review, 114, 1, Pp. 164-178.

Gregory S. Warrington. 2018. "Quantifying Gerrymandering Using the Vote Distribution."
Election Law Journal: Rules, Politics, and Policy. Pp. 39-57.http://doi.org/10.1089/elj.2017.0447

Samuel S.-H. Wang. 2016. "Three Tests for Practical Evaluation of Partisan Gerrymandering."
Stanford Law Review, 68, Pp. 1263 - 1321.

Gregory Herschlag, Han Sung Kang, Justin Luo, Christy Vaughn Graves, Sachet Bangia,
Robert Ravier & Jonathan C. Mattingly (2020) Quantifying Gerrymandering in North Carolina,
Statistics and Public Policy, 7:1, 30-38, DOI: 10.1080/2330443X.2020.1796400
}
\concept{analyze}
