% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportMappings.R
\name{exportMappings}
\alias{exportMappings}
\alias{exportMappings.redcapApiConnection}
\title{Exports the Event-Form Mappings for a Project}
\usage{
exportMappings(rcon, arms, ...)

\method{exportMappings}{redcapApiConnection}(
  rcon,
  arms = NULL,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}.}

\item{arms}{\code{integerish} A vector of arm numbers that you wish to pull events for (by default,
all events are pulled). Will also accept \code{character}, but will coerce
it to numeric before processing.}

\item{...}{Arguments to be passed to other methods}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
Retrieve a data frame giving the events-form mapping for a project.
}
\details{
The data frame that is returned shows the arm number, unique 
event name, and forms mapped in a project.
 
If the project information reports that the project is not longitudinal, 
a data frame with 0 rows is returned without calling the API.
}
\section{REDCap API Documentation}{

This function allows you to export the instrument-event mappings for a project 
(i.e., how the data collection instruments are designated for certain events in a 
longitudinal project).

NOTE: this only works for longitudinal projects
}

\section{REDCap Version}{

5.8.2+ (and earlier, but we don't know how much earlier)
}

\section{Known REDCap Limitations}{
 
None
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/vubiostat/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
