% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlockREDCap.R
\name{unlockREDCap}
\alias{unlockREDCap}
\title{Create a set of connections to redcap in the current (or specified 
environment) from API_KEYs stored in a crypto locker. On the first
execution it will ask to set the password for this locker. Next it
will ask for the API_KEYs specified. It will request the user enter
each key using getPass and store it in memory. If an API_KEY doesn't
work, it will automatically delete it from the
crypto locker and ask again on next execution.}
\usage{
unlockREDCap(
  connections,
  url,
  keyring,
  envir = NULL,
  passwordFUN = getPass::getPass,
  ...
)
}
\arguments{
\item{connections}{character vector. A list of strings that define the
connections with associated API_KEYs to load into environment. Each
name should correspond to a REDCap project for traceability, but 
it can be anything. The variable name in the environment is this
name, or if a named vector the name associated.}

\item{url}{character. The url of the REDCap server's api.}

\item{keyring}{character. Potential keyring, not used by default.}

\item{envir}{environment. The target environment for the connections. Defaults to NULL
which returns the keys as a list. Use \code{\link{globalenv}} to assign the
global environment.}

\item{passwordFUN}{function. Function to get the password for the keyring. Defaults to getPass::getPass().}

\item{\dots}{Additional arguments passed to \code{\link{redcapConnection}}.}
}
\value{
If \code{envir} is NULL returns a list of opened connections. Otherwise
        returns NULL and connections are assigned into the specified \code{envir}.
}
\description{
If one forgets the password, or wishes to start over: `keyring::keyring_delete("keyring")`
}
\details{
For production servers where the password must be stored in a readable
plain text file, it will search for `../<basename>.yml`. DO NOT USE
this unless one is a sysadmin, as this defeats the security and purpose of
a local encrypted file. The expected structure of this yaml file is
as follows:

\preformatted{
other-config-stuff1: blah blah
redcapAPI:
  args:
    url: https://redcap.vanderbilt.edu/api/
  keys:
    intake: THIS_IS_THE_INTAKE_DATABASE_APIKEY
    details: THIS_IS_THE_DETAILS_DATABASE_APIKEY
other-config-stuff2: blah blah
other-config-stuff3: blah blah
}

IMPORTANT: Make sure that R is set to NEVER save workspace to .RData
as this *is* writing the API_KEY to a local
file in clear text.
}
\examples{
\dontrun{
  # Cuts down on password requests on MAC
options(keyring_backend=keyring::backend_file)

unlockREDCap(c(test_conn    = 'TestRedcapAPI',
               sandbox_conn = 'SandboxAPI'),
             keyring      = 'MyKeyring',
             envir        = globalenv(),
             url          = 'https://<REDCAP_URL>/api/') 
}

}
