% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportReportsTyped.R
\name{exportReportsTyped}
\alias{exportReportsTyped}
\alias{exportReportsTyped.redcapApiConnection}
\title{Export a Report from a REDCap Project}
\usage{
exportReportsTyped(rcon, report_id, ...)

\method{exportReportsTyped}{redcapApiConnection}(
  rcon,
  report_id,
  drop_fields = NULL,
  na = list(),
  validation = list(),
  cast = list(),
  assignment = list(label = stripHTMLandUnicode, units = unitsFieldAnnotation),
  ...,
  config = list(),
  api_param = list(),
  csv_delimiter = ","
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object}

\item{report_id}{\code{integerish(1)} The ID number of the report to 
be exported.}

\item{...}{Argument to pass to other methods.}

\item{drop_fields}{\code{character}. A vector of field names to remove 
from the export. Ignore if length = 0.}

\item{na}{A named \code{list} of user specified functions to determine if the
data is NA. This is useful when data is loaded that has coding for NA, e.g.
-5 is NA. Keys must correspond to a truncated REDCap field type, i.e.
{date_, datetime_, datetime_seconds_, time_mm_ss, time_hh_mm_ss, time, float,
number, calc, int, integer, select, radio, dropdown, yesno, truefalse,
checkbox, form_complete, sql}. The function will be provided the variables
(x, field_name, coding). The function must return a vector of logicals
matching the input. It defaults to \code{\link{isNAorBlank}} for all
entries.}

\item{validation}{A named \code{list} of user specified validation functions. The 
same named keys are supported as the na argument. The function will be 
provided the variables (x, field_name, coding). The function must return a
vector of logical matching the input length. Helper functions to construct
these are \code{\link{valRx}} and \code{\link{valChoice}}. Only fields that
are not identified as NA will be passed to validation functions.}

\item{cast}{A named \code{list} of user specified class casting functions. The
same named keys are supported as the na argument. The function will be 
provided the variables (x, field_name, coding). The function must return a
vector of logical matching the input length. See \code{\link{fieldValidationAndCasting}}}

\item{assignment}{A named \code{list} of functions. These functions are provided, field_name,
label, description and field_type and return a list of attributes to assign
to the column. Defaults to creating a label attribute from the stripped
HTML and UNICODE raw label and scanning for units={"UNITS"} in description
to use as a units attribute.}

\item{config}{named \code{list}. Additional configuration parameters to pass to \code{httr::POST},
These are appended to any parameters in \code{rcon$config}}

\item{api_param}{named \code{list}. Additional API parameters to pass into the body of the
API call. This provides users to execute calls with options that may not
otherwise be supported by redcapAPI.}

\item{csv_delimiter}{character. One of \code{c(",", "\t", ";", "|", "^")}. Designates the
delimiter for the CSV file received from the API.}
}
\description{
Export a Report from a REDCap Project
}
\details{
This method allows you to export the data set of a report 
  created on a project's 'Data Exports, Reports, and Stats' page.

Note about export rights: Please be aware that Data Export user 
rights will be applied to this API request. For example, if you have 
'No Access' data export rights in the project, then the API report export 
will fail and return an error. And if you have 'De-Identified' or 'Remove 
All Identifier Fields' data export rights, then some data fields *might* 
be removed and filtered out of the data set returned from the API. 
To make sure that no data is unnecessarily filtered out of your API 
request, you should have 'Full Data Set' export rights in the project.
}
