% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportSurveyParticipants.R
\name{exportSurveyParticipants}
\alias{exportSurveyParticipants}
\alias{exportSurveyParticipants.redcapApiConnection}
\title{Exports details of participants for a given survey}
\usage{
exportSurveyParticipants(rcon, instrument, event, ...)

\method{exportSurveyParticipants}{redcapApiConnection}(
  rcon,
  instrument,
  event,
  ...,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}.}

\item{instrument}{A string type holding the name of "instrument" or survey the participants are managed under}

\item{event}{A string type holding the name of the event that the instrument belongs to}

\item{...}{additional arguments to pass to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\description{
Retrieving dataframe of survey participants managed in REDCap
}
\details{
REDCap allows the user to manage a list of participants (if they are known) for each survey. This function 
pulls this information into a dataframe. The contents of the dataframe are the contact fields of the participants, 
the link to the survey for that participant if the participant hasn't completed the survey yet (otherwise, NA), 
the participants record id, and other information.
}
\author{
Paddy Tobias
}
