% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importRecords.R
\name{importRecords}
\alias{importRecords}
\alias{importRecords.redcapDbConnection}
\alias{importRecords.redcapApiConnection}
\title{Import Records to a REDCap Database}
\usage{
importRecords(
  rcon,
  data,
  overwriteBehavior = c("normal", "overwrite"),
  returnContent = c("count", "ids", "nothing"),
  returnData = FALSE,
  logfile = "",
  ...
)

\method{importRecords}{redcapDbConnection}(
  rcon,
  data,
  overwriteBehavior = c("normal", "overwrite"),
  returnContent = c("count", "ids", "nothing"),
  returnData = FALSE,
  logfile = "",
  ...
)

\method{importRecords}{redcapApiConnection}(
  rcon,
  data,
  overwriteBehavior = c("normal", "overwrite"),
  returnContent = c("count", "ids", "nothing"),
  returnData = FALSE,
  logfile = "",
  ...,
  bundle = NULL,
  batch.size = -1
)
}
\arguments{
\item{rcon}{A REDCap connection object as created by \code{redcapConnection}.}

\item{data}{A \code{data.frame} to be imported to the REDCap project.}

\item{overwriteBehavior}{Character string.  'normal' prevents blank
fields from overwriting populated fields.  'overwrite' causes blanks to
overwrite data in the REDCap database.}

\item{returnContent}{Character string.  'count' returns the number of
records imported; 'ids' returns the record ids that are imported;
'nothing' returns no message.}

\item{returnData}{Logical.  Prevents the REDCap import and instead
returns the data frame that would have been given
for import.  This is sometimes helpful if the API import fails without
providing an informative message. The data frame can be written to a csv
and uploaded using the interactive tools to troubleshoot the
problem.  Please shoot me an e-mail if you find errors I havne't
accounted for.}

\item{logfile}{An optional filepath (preferably .txt) in which to print the
log of errors and warnings about the data.
If \code{""}, the log is printed to the console.}

\item{...}{Arguments to be passed to other methods.}

\item{bundle}{A \code{redcapBundle} object as created by
\code{exportBundle}.}

\item{batch.size}{Specifies size of batches.  A negative value
indicates no batching.}
}
\description{
Imports records from a \code{data.frame} to a REDCap Database
}
\details{
A record of imports through the API is recorded in the Logging section
of the project.

\code{importRecords} prevents the most common import errors by testing the
data before attempting the import.  Namely
\enumerate{
  \item Check that all variables in \code{data} exist in the REDCap data dictionary.
  \item Check that the study id variable exists
  \item Force the study id variable to the first position in the data frame (with a warning)
  \item Remove calculated fields (with a warning)
  \item Verify that REDCap date fields are represented in the data frame as
    either character, POSIXct, or Date class objects.
  \item Determine if values are within their specified validation limits.
}

See the documentation for \code{\link{validateImport}} for detailed
explanations of the validation.
}
\references{
See the REDCap API documentation at your institution's REDCap documentation.
}
\seealso{
\code{\link{validateImport}}
}
\author{
Benjamin Nutter\cr
with thanks to Josh O'Brien and etb (see references)
}
