% Generated by roxygen2 (4.0.2): do not edit by hand
\name{exportRecords}
\alias{exportRecords}
\alias{exportRecords.redcapApiConnection}
\alias{exportRecords.redcapDbConnection}
\alias{exportRecords_offline}
\alias{queryRecords}
\title{Export Records from a REDCap Database}
\usage{
queryRecords(rcon, fields = NULL, forms = NULL, records = NULL,
  events = NULL)

exportRecords(rcon, factors = TRUE, fields = NULL, forms = NULL,
  records = NULL, events = NULL, labels = TRUE, dates = TRUE,
  survey = TRUE, dag = TRUE, checkboxLabels = FALSE, ...)

\method{exportRecords}{redcapDbConnection}(rcon, factors = TRUE,
  fields = NULL, forms = NULL, records = NULL, events = NULL,
  labels = TRUE, dates = TRUE, survey = TRUE, dag = TRUE,
  checkboxLabels = FALSE, ...)

\method{exportRecords}{redcapApiConnection}(rcon, factors = TRUE,
  fields = NULL, forms = NULL, records = NULL, events = NULL,
  labels = TRUE, dates = TRUE, survey = TRUE, dag = TRUE,
  checkboxLabels = FALSE, ..., batch.size = -1, proj = NULL)

exportRecords_offline(datafile, meta_data, factors = TRUE, fields = NULL,
  forms = NULL, labels = TRUE, dates = TRUE, checkboxLabels = FALSE,
  ...)
}
\arguments{
\item{rcon}{A REDCap connection object as created by \code{redcapConnection}.}

\item{fields}{A character vector of fields to be returned.  If \code{NULL},
all fields are returned.}

\item{forms}{A character vector of forms to be returned.  If \code{NULL},
all forms are returned.}

\item{records}{A vector of study id's to be returned.  If \code{NULL}, all
subjects are returned.}

\item{events}{A character vector of events to be returned from a
longitudinal database.  If \code{NULL}, all events are returned.}

\item{factors}{Logical.  Determines if categorical data from the database is
returned as numeric codes or labelled factors.}

\item{labels}{Logical.  Determines if the variable labels are applied to
the data frame.}

\item{dates}{Logical. Determines if date variables are converted to POSIXct
format during the download.}

\item{survey}{specifies whether or not to export the survey identifier field
(e.g., "redcap_survey_identifier") or survey timestamp fields
(e.g., form_name+"_timestamp") when surveys are utilized in the project.
If you do not pass in this flag, it will default to "false". If set to
"true", it will return the redcap_survey_identifier field and also the
survey timestamp field for a particular survey when at least
one field from that survey is being exported. NOTE: If the survey
identifier field or survey timestamp fields are imported via API data
import, they will simply be ignored since they are not real fields in
the project but rather are pseudo-fields.}

\item{dag}{specifies whether or not to export the "redcap_data_access_group"
field when data access groups are utilized in the project. If you do not
pass in this flag, it will default to "false". NOTE: This flag is only
viable if the user whose token is being used to make the API request is
*not* in a data access group. If the user is in a group, then this
flag will revert to its default value.}

\item{checkboxLabels}{Logical. Determines the format of labels in checkbox
variables.  If \code{FALSE} labels are applies as "Unchecked"/"Checked".
If \code{TRUE}, they are applied as ""/"[field_labe]" where [field_label]
is the label assigned to the level in the data dictionary.
This option is only available after REDCap version 6.0.}

\item{...}{Additional arguments to be passed between methods.}

\item{batch.size}{Integer.  Specifies the number of subjects to be included
in each batch of a batched export.  Non-positive numbers export the
entire project in a single batch. Batching the export may be beneficial
to prevent tying up smaller servers.  See details for more explanation.}

\item{proj}{A \code{redcapProject} object as created by \code{redcapProjectInfo}.}

\item{datafile}{For the offline version, a character string giving the location
of the dataset downloaded from REDCap.  Note that this should be the raw
(unlabeled) data set.}

\item{meta_data}{A text string giving the location of the data dictionary
downloaded from REDCap.}
}
\description{
Exports records from a REDCap Database, allowing for
  subsets of subjects, fields, records, and events.
}
\details{
A record of exports through the API is recorded in the Logging section
of the project.

The 'offline' version of the function operates on the raw (unlabeled) data
file downloaded from REDCap along with the data dictionary.
This is made available for instances where the API can not be accessed for
some reason (such as waiting for API approval from the REDCap administrator).

It is unnecessary to include "redcap_event_name" in the fields argument.
This field is automatically exported for any longitudinal database.
If the user does include it in the fields argument, it is removed quietly
in the parameter checks.

A 'batched' export is one where the export is performed over a series of
API calls rather than one large call.  For large projects on small servers,
this may prevent a single user from tying up the server and forcing others
to wait on a larger job.  The batched export is performed by first
calling the API to export the subject identifier field (the first field
in the meta data).  The unique ID's are then assigned a batch number with
no more than \code{batch.size} ID's in any single batch.  The batches are
exported from the API and stacked together.

In longitudinal projects, \code{batch.size} may not necessarily be the
number of records exported in each batch.  If \code{batch.size} is 10 and
there are four records per patient, each batch will consist of 40 records.
Thus, if you are concerned about tying up the server with a large,
longitudinal project, it would be prudent to use a smaller batch size.
}
\examples{
\dontrun{
> #*** Note: I cannot provide working examples
> #*** without compromising security.  Instead, I will try to
> #*** offer up sample code with the matching results
>
>
> #*** Create the connection object
> rcon <- redcapConnection(url=[YOUR_REDCAP_URL], token=[API_TOKEN])
>
>
> #*** Export the full data set
> BMD <- exportRecords(rcon)
> head(BMD)
patient_id redcap_event_name      bmi patient_characteristics_complete
1          1       entry_arm_1 38.18765                                2
2          1  dxa_scan_1_arm_1       NA                               NA
3          1  dxa_scan_2_arm_1       NA                               NA
4          1  dxa_scan_3_arm_1       NA                               NA
5          2       entry_arm_1 24.40972                                2
6          2  dxa_scan_1_arm_1       NA                               NA
contact_date hip_left_bmd hip_left_tscore hip_right_bmd hip_right_tscore
1         <NA>           NA              NA            NA               NA
2   2013-06-12           NA              NA            NA               NA
3   2009-02-11           NA              NA            NA               NA
4   2011-02-26           NA              NA            NA               NA
5         <NA>           NA              NA            NA               NA
6   2010-11-06        0.697              -2            NA               NA
neck_left_bmd neck_left_tscore neck_right_bmd neck_right_tscore spine_bmd
1            NA               NA             NA                NA        NA
2         0.664             -2.0             NA                NA        NA
3         0.675             -1.9             NA                NA        NA
4         0.734             -1.5             NA                NA        NA
5            NA               NA             NA                NA        NA
6         0.521             -3.0             NA                NA     0.899
spine_tscore dxa_scan_summary_complete
1           NA                        NA
2           NA                         2
3           NA                         2
4           NA                         2
5           NA                        NA
6         -1.3                         2
>
>
>
> #*** Export only the patient_characteristics form
> BMD <- exportRecords(rcon, forms="patient_characteristics")
> head(BMD)
patient_id redcap_event_name      bmi patient_characteristics_complete
1          1       entry_arm_1 38.18765                                2
2          1  dxa_scan_1_arm_1       NA                               NA
3          1  dxa_scan_2_arm_1       NA                               NA
4          1  dxa_scan_3_arm_1       NA                               NA
5          2       entry_arm_1 24.40972                                2
6          2  dxa_scan_1_arm_1       NA                               NA
>
>
> #*** Export only the second scan
> BMD <- exportRecords(rcon, events="dxa_scan_2_arm_1", forms="dxa_scan_summary")
> head(BMD)
patient_id redcap_event_name contact_date hip_left_bmd hip_left_tscore
1          1  dxa_scan_2_arm_1   2009-02-11           NA              NA
2          2  dxa_scan_2_arm_1   2012-10-30        0.684            -2.1
3          3  dxa_scan_2_arm_1   2013-02-06        1.007             0.0
4          4  dxa_scan_2_arm_1   2007-09-20           NA              NA
5          5  dxa_scan_2_arm_1   2006-07-07           NA              NA
6          6  dxa_scan_2_arm_1   2006-10-25           NA              NA
hip_right_bmd hip_right_tscore neck_left_bmd neck_left_tscore neck_right_bmd
1            NA               NA         0.675             -1.9             NA
2            NA               NA         0.524             -2.9             NA
3            NA               NA         0.897             -1.0             NA
4            NA               NA         0.632             -2.0             NA
5            NA               NA         0.835             -0.1             NA
6            NA               NA            NA               NA           0.54
neck_right_tscore spine_bmd spine_tscore dxa_scan_summary_complete
1                NA        NA           NA                         2
2                NA     0.915         -1.2                         2
3                NA     1.109         -0.6                         2
4                NA     0.864         -1.7                         2
5                NA     0.869         -1.6                         2
6              -2.8     0.830         -2.0                         2
>
>
> #*** Retrieve the first scan for patients 38 and 103
> BMD <- exportRecords(rcon, records=c(38, 103),
                       forms="dxa_scan_summary", events="dxa_scan_1_arm_1")
> BMD
patient_id redcap_event_name contact_date hip_left_bmd hip_left_tscore
1         38  dxa_scan_1_arm_1   2008-05-07           NA              NA
2        103  dxa_scan_1_arm_1   2010-04-21        0.856            -1.2
hip_right_bmd hip_right_tscore neck_left_bmd neck_left_tscore neck_right_bmd
1            NA               NA         0.595             -2.3             NA
2            NA               NA         0.789             -1.8             NA
neck_right_tscore spine_bmd spine_tscore dxa_scan_summary_complete
1                NA     0.770         -2.5                         2
2                NA     1.023         -1.3                         2
}
}
\author{
Jeffrey Horner
}
\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}

This functionality were originally developed by Jeffrey Horner in the \code{redcap} package.
\url{https://github.com/vubiostat/redcap}

See also \code{read_redcap_oneshot} in the \code{REDCapR} package by Will Beasley.
\url{https://github.com/OuhscBbmc/REDCapR}
}

