library(rearrr)
context("roll_elements()")

test_that("examples in roll_elements()", {

  ## Testing 'roll_elements(1:10, n = 2)'                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(1:10, n = 2)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(3, 4, 5, 6, 7, 8, 9, 10, 1, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements(1:10, n = 2)'                          ####



  ## Testing 'roll_elements_vec(1:10, n = -2)'                              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements_vec(1:10, n = -2)
  # Testing class
  expect_equal(
    class(output_19148),
    "integer",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "integer")
  # Testing values
  expect_equal(
    output_19148,
    c(9, 10, 1, 2, 3, 4, 5, 6, 7, 8),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    10L)
  ## Finished testing 'roll_elements_vec(1:10, n = -2)'                     ####



  ## Testing 'roll_elements(3:12, n_fn = median_index)'                     ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(3:12, n_fn = median_index)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(9, 10, 11, 12, 3, 4, 5, 6, 7, 8),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements(3:12, n_fn = median_index)'            ####



  ## Testing 'roll_elements(3:12, n_fn = create_n_fn(media...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(3:12, n_fn = create_n_fn(median, negate = TRUE))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(5, 6, 7, 8, 9, 10, 11, 12, 3, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements(3:12, n_fn = create_n_fn(media...'     ####



  ## Testing 'roll_elements( 1:10, n_fn = quantile_index, ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(
      1:10,
      n_fn = quantile_index,
      prob = 0.2
    )
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(4, 5, 6, 7, 8, 9, 10, 1, 2, 3),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements( 1:10, n_fn = quantile_index, ...'     ####



  # Set seed
  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = 1:20,
    "y" = runif(20)*10,
    "g" = rep(1:4, each = 5),
    stringsAsFactors = FALSE
  )


  ## Testing 'roll_elements(df, n = 2)'                                     ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19040 <- roll_elements(df, n = 2)
  # Testing class
  expect_equal(
    class(output_19040),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19040[["x"]],
    c(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["y"]],
    c(2.8614, 8.30448, 6.41746, 5.19096, 7.36588, 1.34667, 6.56992,
      7.05065, 4.57742, 7.19112, 9.34672, 2.55429, 4.62293, 9.40015,
      9.78226, 1.17487, 4.74997, 5.60333, 9.14806, 9.37075),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["g"]],
    c(1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19040),
    c("x", "y", "g", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19040),
    c("integer", "numeric", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19040),
    c("integer", "double", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19040),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19040)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements(df, n = 2)'                            ####


  ## Testing 'roll_elements(df, n = -2)'                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(df, n = -2)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(19, 20, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
      17, 18),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(4.74997, 5.60333, 9.14806, 9.37075, 2.8614, 8.30448, 6.41746,
      5.19096, 7.36588, 1.34667, 6.56992, 7.05065, 4.57742, 7.19112,
      9.34672, 2.55429, 4.62293, 9.40015, 9.78226, 1.17487),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["g"]],
    c(4, 4, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "g", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements(df, n = -2)'                           ####


  ## Testing 'roll_elements(df, cols = "x", n = -2)'                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(df, cols = "x", n = -2)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["y"]],
    c(9.14806, 9.37075, 2.8614, 8.30448, 6.41746, 5.19096, 7.36588,
      1.34667, 6.56992, 7.05065, 4.57742, 7.19112, 9.34672, 2.55429,
      4.62293, 9.40015, 9.78226, 1.17487, 4.74997, 5.60333),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(19, 20, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
      17, 18),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("y", "g", "x", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "integer", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "integer", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements(df, cols = "x", n = -2)'               ####


  ## Testing 'roll_elements( df %>% dplyr::group_by(g), n_...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(
      df %>% dplyr::group_by(g),
      n_fn = median_index,
      negate = TRUE
    )
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(3, 4, 5, 1, 2, 8, 9, 10, 6, 7, 13, 14, 15, 11, 12, 18, 19, 20,
      16, 17),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(2.8614, 8.30448, 6.41746, 9.14806, 9.37075, 1.34667, 6.56992,
      7.05065, 5.19096, 7.36588, 9.34672, 2.55429, 4.62293, 4.57742,
      7.19112, 1.17487, 4.74997, 5.60333, 9.40015, 9.78226),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "g", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_elements( df %>% dplyr::group_by(g), n_...'     ####

})

test_that("fuzz testing roll_elements()", {
  xpectr::set_test_seed(87)

  # Create a data frame
  df <- data.frame(
    "x" = 1:20,
    "y" = runif(20)*10,
    "g" = rep(1:4, each = 5),
    stringsAsFactors = FALSE
  )


  ## Testing 'df'                                                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df[["x"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
      19, 20),
    tolerance = 1e-4)
  expect_equal(
    df[["y"]],
    c(0.16069, 2.91406, 0.42461, 8.57657, 0.30616, 0.69494, 1.80087,
      3.20887, 9.66793, 4.04378, 4.5842, 8.53505, 1.81486, 7.6291,
      2.49556, 4.77568, 8.43542, 6.85304, 2.91238, 2.31441),
    tolerance = 1e-4)
  expect_equal(
    df[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df),
    c("integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df'                                                  ####



  # Generate expectations for 'roll_elements'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = roll_elements,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1:5), 1, NA),
  #     "cols" = list(NULL, c("x", "y"), "x", c("x", NA)),
  #     "n" = list(2, -2, 0, NA),
  #     "n_fn" = list(NULL, median_index, NA),
  #     "n_col_name" = list(".n", NA)
  #   ),
  #   extra_combinations = list(
  #     list("data" = dplyr::group_by(df, g), "cols" = c("x", "y"), "n" = NULL, "n_fn" = median_index),
  #     list("data" = 1:5, "cols" = "x"),
  #     list("data" = df, "cols" = c("x", "y"), "n" = c(2, -2))
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'roll_elements'                                                  ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing roll_elements(data = df, cols = NULL, n = 2,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_elements(data = df, cols = NULL, n = 2, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.42461, 8.57657, 0.30616, 0.69494, 1.80087, 3.20887, 9.66793,
      4.04378, 4.5842, 8.53505, 1.81486, 7.6291, 2.49556, 4.77568,
      8.43542, 6.85304, 2.91238, 2.31441, 0.16069, 2.91406),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["g"]],
    c(1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "g", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = dplyr::group_by(df, g),...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- roll_elements(data = dplyr::group_by(df, g), cols = NULL, n = 2, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["x"]],
    c(3, 4, 5, 1, 2, 8, 9, 10, 6, 7, 13, 14, 15, 11, 12, 18, 19, 20,
      16, 17),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.42461, 8.57657, 0.30616, 0.16069, 2.91406, 3.20887, 9.66793,
      4.04378, 0.69494, 1.80087, 1.81486, 7.6291, 2.49556, 4.5842,
      8.53505, 6.85304, 2.91238, 2.31441, 4.77568, 8.43542),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("x", "y", "g", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("integer", "numeric", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("integer", "double", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = c(1:5), cols = NULL, n ...
  # Changed from baseline: data = c(1:5)
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- roll_elements(data = c(1:5), cols = NULL, n = 2, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_12861),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12861[["Value"]],
    c(3, 4, 5, 1, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12861),
    c("Value", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12861),
    c("integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12861),
    c("integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12861),
    c(5L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12861)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = 1, cols = NULL, n = 2, ...
  # Changed from baseline: data = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- roll_elements(data = 1, cols = NULL, n = 2, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_18304),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18304[["Value"]],
    1,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_18304),
    c("Value", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18304),
    c("numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18304),
    c("double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18304),
    1:2)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18304)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = NA, cols = NULL, n = 2,...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(roll_elements(data = NA, cols = NULL, n = 2, n_fn = NULL, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = NULL, cols = NULL, n = ...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(roll_elements(data = NULL, cols = NULL, n = 2, n_fn = NULL, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = 1:5, cols = "x", n = 2,...
  # Changed from baseline: data, cols
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(roll_elements(data = 1:5, cols = "x", n = 2, n_fn = NULL, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = c("x", "y"),...
  # Changed from baseline: data, cols, n
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- roll_elements(data = df, cols = c("x", "y"), n = c(2, -2), n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["x"]],
    c(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["y"]],
    c(2.91238, 2.31441, 0.16069, 2.91406, 0.42461, 8.57657, 0.30616,
      0.69494, 1.80087, 3.20887, 9.66793, 4.04378, 4.5842, 8.53505,
      1.81486, 7.6291, 2.49556, 4.77568, 8.43542, 6.85304),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("g", "x", "y", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("integer", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("integer", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = dplyr::group_by(df, g),...
  # Changed from baseline: data, cols, n, n_fn
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- roll_elements(data = dplyr::group_by(df, g), cols = c("x", "y"), n = NULL, n_fn = median_index, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_16569),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16569[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["x"]],
    c(4, 5, 1, 2, 3, 9, 10, 6, 7, 8, 14, 15, 11, 12, 13, 19, 20, 16,
      17, 18),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["y"]],
    c(8.57657, 0.30616, 0.16069, 2.91406, 0.42461, 9.66793, 4.04378,
      0.69494, 1.80087, 3.20887, 7.6291, 2.49556, 4.5842, 8.53505,
      1.81486, 2.91238, 2.31441, 4.77568, 8.43542, 6.85304),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16569),
    c("g", "x", "y", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16569),
    c("integer", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16569),
    c("integer", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16569),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16569)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = c("x", "y"),...
  # Changed from baseline: cols = c("x", "y")
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- roll_elements(data = df, cols = c("x", "y"), n = 2, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_17050),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17050[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_17050[["x"]],
    c(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17050[["y"]],
    c(0.42461, 8.57657, 0.30616, 0.69494, 1.80087, 3.20887, 9.66793,
      4.04378, 4.5842, 8.53505, 1.81486, 7.6291, 2.49556, 4.77568,
      8.43542, 6.85304, 2.91238, 2.31441, 0.16069, 2.91406),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17050),
    c("g", "x", "y", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17050),
    c("integer", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17050),
    c("integer", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17050),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17050)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = "x", n = 2, ...
  # Changed from baseline: cols = "x"
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- roll_elements(data = df, cols = "x", n = 2, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["y"]],
    c(0.16069, 2.91406, 0.42461, 8.57657, 0.30616, 0.69494, 1.80087,
      3.20887, 9.66793, 4.04378, 4.5842, 8.53505, 1.81486, 7.6291,
      2.49556, 4.77568, 8.43542, 6.85304, 2.91238, 2.31441),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["x"]],
    c(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      1, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("y", "g", "x", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("numeric", "integer", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("double", "integer", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = c("x", NA), ...
  # Changed from baseline: cols = c("x", NA)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(roll_elements(data = df, cols = c("x", NA), n = 2, n_fn = NULL, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"x\", NA, \".n\")' failed: Contains missing values (element 2)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = NA...
  # Changed from baseline: n = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(roll_elements(data = df, cols = NULL, n = NA, n_fn = NULL, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'n': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = -2...
  # Changed from baseline: n = -2
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- roll_elements(data = df, cols = NULL, n = -2, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["x"]],
    c(19, 20, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
      17, 18),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["y"]],
    c(2.91238, 2.31441, 0.16069, 2.91406, 0.42461, 8.57657, 0.30616,
      0.69494, 1.80087, 3.20887, 9.66793, 4.04378, 4.5842, 8.53505,
      1.81486, 7.6291, 2.49556, 4.77568, 8.43542, 6.85304),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["g"]],
    c(4, 4, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("x", "y", "g", ".n"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("integer", "numeric", "integer", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("integer", "double", "integer", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = 0,...
  # Changed from baseline: n = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- roll_elements(data = df, cols = NULL, n = 0, n_fn = NULL, n_col_name = ".n")
  # Testing class
  expect_equal(
    class(output_14622),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14622[["x"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
      19, 20),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["y"]],
    c(0.16069, 2.91406, 0.42461, 8.57657, 0.30616, 0.69494, 1.80087,
      3.20887, 9.66793, 4.04378, 4.5842, 8.53505, 1.81486, 7.6291,
      2.49556, 4.77568, 8.43542, 6.85304, 2.91238, 2.31441),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14622),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = NU...
  # Changed from baseline: n = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(roll_elements(data = df, cols = NULL, n = NULL, n_fn = NULL, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * exactly one of {'n', 'n_fn'} must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = 2,...
  # Changed from baseline: n_fn = median_index
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(roll_elements(data = df, cols = NULL, n = 2, n_fn = median_index, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * exactly one of {'n', 'n_fn'} must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = 2,...
  # Changed from baseline: n_fn = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(roll_elements(data = df, cols = NULL, n = 2, n_fn = NA, n_col_name = ".n"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'n_fn': Must be a function (or 'NULL'), not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = 2,...
  # Changed from baseline: n_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(roll_elements(data = df, cols = NULL, n = 2, n_fn = NULL, n_col_name = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'n_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_elements(data = df, cols = NULL, n = 2,...
  # Changed from baseline: n_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_15603 <- roll_elements(data = df, cols = NULL, n = 2, n_fn = NULL, n_col_name = NULL)
  # Testing class
  expect_equal(
    class(output_15603),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15603[["x"]],
    c(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["y"]],
    c(0.42461, 8.57657, 0.30616, 0.69494, 1.80087, 3.20887, 9.66793,
      4.04378, 4.5842, 8.53505, 1.81486, 7.6291, 2.49556, 4.77568,
      8.43542, 6.85304, 2.91238, 2.31441, 0.16069, 2.91406),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["g"]],
    c(1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15603),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15603),
    c("integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15603),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15603),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15603)),
    character(0),
    fixed = TRUE)

  ## Finished testing 'roll_elements'                                         ####
  #


})
