% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/most_centered.R
\name{is_most_centered}
\alias{is_most_centered}
\title{Find which data point is closest to the centroid}
\usage{
is_most_centered(..., na.rm = FALSE)
}
\arguments{
\item{...}{\code{Numeric vector}s.}

\item{na.rm}{Whether to ignore missing values. At least one data point must be complete. (Logical)}
}
\value{
Logical vector (\code{TRUE}/\code{FALSE}) indicating if a data point is the most centered.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Finds the data point with the
shortest distance to the centroid.

To get the coordinates of the most centered data point,
use \code{\link[rearrr:most_centered]{most_centered()}} instead.
}
\examples{
\donttest{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create three vectors
x <- runif(10)
y <- runif(10)
z <- runif(10)

# Find the data point closest to the centroid
is_most_centered(x, y, z)

# Compare to coordinates for the most centered
most_centered(x, y, z)

#
# For data.frames
#

# Create data frame
df <- data.frame(
  "x" = x,
  "y" = y,
  "z" = z,
  "g" = rep(1:2, each = 5)
)

# Filter the data points
# closest to the centroid
df \%>\%
  dplyr::filter(is_most_centered(x, y, z))

# When 'df' is grouped
df \%>\%
  dplyr::group_by(g) \%>\%
  dplyr::filter(is_most_centered(x, y, z))

# Add as column
df \%>\%
  dplyr::group_by(g) \%>\%
  dplyr::mutate(mc = is_most_centered(x, y, z))
}
}
\seealso{
Other coordinate functions: 
\code{\link{centroid}()},
\code{\link{create_origin_fn}()},
\code{\link{midrange}()},
\code{\link{most_centered}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{coordinate functions}
