% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xlsb.R
\name{read_xlsb}
\alias{read_xlsb}
\title{Read xlsb workbook}
\usage{
read_xlsb(path, sheet = NULL, range = NULL, col_names = TRUE, 
 col_types = NULL, na = "", trim_ws = TRUE, skip = 0, ...)
}
\arguments{
\item{path}{Path to the xlsb workbook}

\item{sheet}{Name or index of the sheet to read. If the sheet name is specified as part of the range, this parameter is ignored}

\item{range}{A named range or a string representing an excel range (of the form Sheet!A1:D10) or a cellranger object}

\item{col_names}{TRUE uses the first row as the column name, FALSE sets names to column.#, or a character vector}

\item{col_types}{NULL to imply type from spreadsheet or one of ignore/logical/numeric/date/string per column}

\item{na}{Single string or array of strings to interpret as missing}

\item{trim_ws}{Trim whitespace from strings}

\item{skip}{Number of rows to skip before reading data}

\item{...}{Additional options. Pass debug = TRUE to return xlsb environment}
}
\description{
Imports a region from an xlsb workbook
}
\examples{
read_xlsb(path = system.file("extdata", "TestBook.xlsb", package = "readxlsb"), 
 range = "PORTFOLIO")

}
