% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_lines.R
\name{read_lines}
\alias{read_lines}
\alias{read_lines_raw}
\title{Read lines from a file or string.}
\usage{
read_lines(file, skip = 0, n_max = -1L, locale = default_locale(),
  na = character(), progress = interactive())

read_lines_raw(file, skip = 0, n_max = -1L, progress = interactive())
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded. Remote gz files can also be automatically downloaded &
   decompressed.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Number of lines to read. If \code{n_max} is -1, all lines in
file will be read.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link{locale}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to use for missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session. The display is updated every 50,000 values
and will only display if estimated reading time is 5 seconds or more.}
}
\value{
\code{read_lines}: A character vector with one element for each line.
  \code{read_lines_raw}: A list containing a raw vector for each line.
}
\description{
Read lines from a file or string.
}
\examples{
read_lines(readr_example("mtcars.csv"))
read_lines("1\\n\\n2")
read_lines("\\n")

read_lines_raw(readr_example("mtcars.csv"))
}

