% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{datasource}
\alias{datasource}
\title{Create a source object.}
\usage{
datasource(file, skip = 0, comment = "")
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded. Remote gz files can also be automatically downloaded &
   decompressed.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{skip}{Number of lines to skip before reading data.}
}
\description{
Create a source object.
}
\examples{
# Literal csv
datasource("a,b,c\\n1,2,3")
datasource(charToRaw("a,b,c\\n1,2,3"))

# Strings
datasource(system.file("extdata/mtcars.csv", package = "readr"))
datasource(system.file("extdata/mtcars.csv.bz2", package = "readr"))
datasource(system.file("extdata/mtcars.csv.zip", package = "readr"))
datasource("https://github.com/hadley/readr/raw/master/inst/extdata/mtcars.csv")

# Connection
datasource(rawConnection(charToRaw("abc\\n123")))
}
\keyword{internal}

