% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/read_delim.R
\name{read_delim}
\alias{read_csv}
\alias{read_csv2}
\alias{read_delim}
\alias{read_tsv}
\title{Read a delimited file into a data frame.}
\usage{
read_delim(file, delim, quote = '\"', escape_backslash = TRUE,
  escape_double = FALSE, na = "NA", col_names = TRUE, col_types = NULL,
  skip = 0, n_max = -1, progress = interactive())

read_csv(file, col_names = TRUE, col_types = NULL, na = "NA", skip = 0,
  n_max = -1, progress = interactive())

read_csv2(file, col_names = TRUE, col_types = NULL, na = "NA", skip = 0,
  n_max = -1, progress = interactive())

read_tsv(file, col_names = TRUE, col_types = NULL, na = "NA", skip = 0,
  n_max = -1, progress = interactive())
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{delim}{Single character used to separate fields within a record.}

\item{quote}{Single character used to quote strings.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimeter character, the quote characer, or
to add special characters like \code{\\n}.}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value \code{""""} represents
a single quote, \code{\"}.}

\item{na}{String to use for missing values.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
  of column names.

  If \code{TRUE}, the first row of the input will be used as the column
  names, and will not be included in the data frame. If \code{FALSE}, column
  names will be generated automatically: X1, X2, X3 etc.

  If \code{col_names} is a character vector, the values will be used as the
  names of the columns, and the first row of the input will be read into
  the first row of the output data frame.}

\item{col_types}{One of \code{NULL}, a list, a named list or a string.

  If \code{NULL}, the column type will be imputed from the first 30 rows
  on the input. This is convenient (and fast), but not robust. If the
  imputation fails, you'll need to supply the correct types yourself.

  If a list, it must contain one "\code{\link{collector}}" for each column.
  If you only want to read a subset of the columns, you can use a named list
  (where the names give the column names). If a column is not mentioned by
  name, it will not be included in the output.

  Alternatively, you can use a compact string representation where each
  character represents one column: c = character, d = double, i = integer,
  l = logical and \code{_} skips the column.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session. The display is updated every 50,000 values
and will only display if estimated reading time is 5 seconds or more.}
}
\value{
A data frame. If there are parsing problems, a warning tells you
  how many, and you can retrieve the details with \code{\link{problems}()}.
}
\description{
\code{read_csv} and \code{read_tsv} are special cases of the general
\code{read_delim}. They're useful for reading the most common types of
flat file data. \code{read_csv2} uses \code{;} for separators, instead of
\code{,}. This is common in European countries which use \code{,} as the
decimal separator.
}
\examples{
# Input sources -------------------------------------------------------------
# Read from a path
read_csv(system.file("extdata/mtcars.csv", package = "readr"))
read_csv(system.file("extdata/mtcars.csv.zip", package = "readr"))
read_csv(system.file("extdata/mtcars.csv.bz2", package = "readr"))
read_csv("https://github.com/hadley/readr/raw/master/inst/extdata/mtcars.csv")

# Or directly from a string (must contain a newline)
read_csv("x,y\\n1,2\\n3,4")

# Column types --------------------------------------------------------------
# By default, readr guess the columns types, looking at the first 100 rows.
# You can override with a compact specification:
read_csv("x,y\\n1,2\\n3,4", col_types = "dc")

# Or with a list of column types:
read_csv("x,y\\n1,2\\n3,4", col_types = list(col_double(), col_character()))

# If there are parsing problems, you get a warning, and can extract
# more details with problems()
y <- read_csv("x\\n1\\n2\\nb", col_types = list(col_double()))
y
problems(y)

# File types ----------------------------------------------------------------
read_csv("a,b\\n1.0,2.0")
read_csv2("a;b\\n1,0;2,0")
read_tsv("a\\tb\\n1.0\\t2.0")
read_delim("a|b\\n1.0|2.0", delim = "|")
}

