% Generated by roxygen2 (4.0.1): do not edit by hand
\name{read.bitmap}
\alias{read.bitmap}
\title{Read in a bitmap image in JPEG, PNG or BMP format}
\usage{
read.bitmap(f, channel, IdentifyByExtension = FALSE, ...)
}
\arguments{
\item{f}{Path to image file}

\item{channel}{Integer identifying channel to return for an RGB image}

\item{IdentifyByExtension}{Identify by file extension only (Default FALSE)}

\item{...}{Additional parameters passed to underlying image readers}
}
\value{
return value
}
\description{
By default uses magic byte to identify file
  (rather than the file extension)
Currently uses readers in bmp, jpeg and png packages.
}
\examples{
img1=read.bitmap(system.file("img", "Rlogo.jpg", package="jpeg"))
str(img1)
img2 <- read.bitmap(system.file("img", "Rlogo.png", package="png"))
# nb the PNG image has an alpha channel
str(img2)
}
\seealso{
\code{\link[jpeg]{readJPEG},\link[png]{readPNG},\link[bmp]{read.bmp}}
}

