% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex-readwrite.R
\name{readGenalex}
\alias{readGenalex}
\title{Read GenAlEx-format genotypes file}
\usage{
readGenalex(file, sep = "\\t", ploidy = 2, na.strings = c("0", "-1", ".",
  "NA", ""), ...)
}
\arguments{
\item{file}{Delimited text file in GenAlEx format, typically exported
as tab- or comma-delimited text from Excel}

\item{sep}{Column separator used when \code{file} was created
(defaults to tab)}

\item{ploidy}{The ploidy of genotypes encoded in \code{file} (defaults
to 2)}

\item{na.strings}{Strings encoding missing data.  Default is to include the
GenAlEx missing values ("0" and "-1") as well as ".", "NA" and "" (empty).}

\item{\dots}{Additional arguments passed to \code{\link{scan}} when
reading data}
}
\value{
An annotated data frame of class \code{'genalex'} containing sample
data, with column names determined by line 3 of the input file.  Special
\code{attributes} of the data frame include:

\item{data.file.name }{The value of \code{file}}
\item{ploidy }{Ploidy of input data}
\item{n.loci }{Number of loci}
\item{n.samples }{Total number of samples}
\item{n.pops }{Number of populations}
\item{pop.labels }{Names of populations}
\item{pop.sizes }{Sizes of populations}
\item{dataset.title }{Dataset title}
\item{sample.title }{Sample title}
\item{pop.title }{Population title}
\item{locus.names }{Names of loci}
\item{locus.columns }{Numeric column position of allele 1 of each locus in
  the data frame, with names matching the corresponding loci}
\item{extra.columns }{\code{data.frame} containing any extra columns given
  in \code{file} to the right of the genotype columns.  Row order is the
  same as for the genotype data.  Data are given their natural types using
  \code{type.convert(..., as.is = TRUE)}, so that characters are
  not converted to factors.  Row names are assigned equal to the
  corresponding sample names.  If no extra columns were found, this
  attribute does not exist.}
\item{genetic.data.format }{\code{"genalex"}, not present in package versions >= 1.0}
}
\description{
Reads genotype data file in GenAlEx format into an annotated data frame of
class \code{'genalex'}.  Internal consistency checks that are allowed by
the GenAlEx format are also performed as data is read.  GenAlEx and its
documentation are available at
\url{http://biology-assets.anu.edu.au/GenAlEx}.
}
\details{
\code{readGenalex} expects a genotype data file in GenAlEx format, which
specifies three header lines describing the structure and content of the
file, followed by lines containing the genotype data, along with optionally
extra columns specifying additional information about the sampled
information for other analyses.  GenAlEx format for a collection of diploid
samples is the following, with columns separated by \code{sep}:

\tabular{llllll}{
  N loci \tab Total N samples \tab N populations \tab N pop 1 \tab N pop 2 \tab ... \cr
  Dataset title \tab \emph{empty} \tab \emph{empty} \tab Name pop 1 \tab Name pop 2 \tab ... \cr
  Sample title \tab Pop title \tab Name locus 1 \tab \emph{empty} \tab Name locus 2 \tab ... \cr
  ID sample 1 \tab ID sample 1 pop \tab Loc 1 allele 1 \tab Loc 1 allele 2 \tab Loc 2 allele 1 \tab ... \cr
  ID sample 2 \tab ID sample 2 pop \tab Loc 1 allele 1 \tab Loc 1 allele 2 \tab Loc 2 allele 1 \tab ... \cr
  ...  \tab ... \tab ...  \tab ...  \tab ...  \tab ... \cr
}

Calling \code{readGenalex} for a file first reads the top 3 header lines,
then reads the remainder of the file checking for consistency with the data
description from the header lines.  It attempts to cleanly ignore extra
delimiters that Excel might add when exporting a delimited file.

After reading, the first two columns of the data frame containing the
sample and population names are stored as \code{character}, while the
genotype columns are stored as \code{numeric}, as that is the specified
type for genotype information in GenAlEx.  As such, it is an error for
these columns to contain non-numeric values that do not match
\code{na.strings}.

Extra columns beyond the genotype columns are allowed. If these columns are
named, they are read along with the genotype columns and are stored as a
data frame in the \code{extra.columns} attribute and
\code{\link{writeGenalex}} will write their values in the columns
immediately to the right of the genotype values.  These data are given
their natural type as if read with
\code{read.table(..., stringsAsFactors = FALSE)}, so that
character values are not converted to factors.  Row names are assigned that
are equivalent to the corresponding sample names.

More information on GenAlEx is available at
\url{http://biology-assets.anu.edu.au/GenAlEx}.  In particular, genotype
information must be encoded numerically.
}
\examples{
gt.file <- system.file("extdata/Qagr_pericarp_genotypes.txt",
                       package = "readGenalex")
gt <- readGenalex(gt.file)
head(gt)
names(attributes(gt))
}
\author{
Douglas G. Scofield
}
\references{
Peakall, R. and Smouse P.E. (2012) GenAlEx 6.5: genetic analysis
in Excel. Population genetic software for teaching and research-an update.
\emph{Bioinformatics} 28, 2537-2539.

Peakall, R. and Smouse P.E. (2006) GENALEX 6: genetic analysis in Excel.
Population genetic software for teaching and research. \emph{Molecular
Ecology Notes} 6, 288-295.
}
\seealso{
\code{\link{read.table}}, \code{\link{type.convert}}
}
\keyword{attribute}
\keyword{file}
\keyword{manip}

