% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex-genetics.R
\name{as.genetics}
\alias{as.genetics}
\alias{as.genetics.genalex}
\title{Convert class \code{'genalex'} object to data frame encoding loci using classes from package \code{'genetics'}}
\usage{
\method{as.genetics}{genalex}(x, phased = FALSE, sep = "/",
  check.annotation = TRUE, ...)
}
\arguments{
\item{x}{Annotated data frame of class \code{'genalex'}}

\item{phased}{Default \code{FALSE}.  If \code{FALSE}, assumes alleles
in \code{x} are unphased so that a genotype of \code{101/107} is
identical to a genotype of \code{107/101}.  This results in the
application of class \code{\link[genetics]{genotype}} to the
genotype data, using \code{\link[genetics]{makeGenotypes}}.  Default
ordering for alleles is applied, which for class
\code{\link[genetics]{genotype}} is to be sorted by frequency; for
more information, see \code{\link[genetics]{genotype}}
If \code{TRUE}, assumes alleles are phased so that a genotype of
\code{101/107} is different from a genotype of \code{107/101}.
This results in the application of class \code{\link[genetics]{haplotype}}
using \code{\link[genetics]{makeHaplotypes}}.  In this case, alleles are
ordered as they are present in the genotype.}

\item{sep}{\emph{Ignored, package }\code{genetics}\emph{ applies it
inconsistently so we cannot reliably apply its effects.}  If it were ever
to work, it would be the haracter to separate alleles in a locus, passed
to \code{\link[genetics]{makeGenotypes}} or
\code{\link[genetics]{makeHaplotypes}}}

\item{check.annotation}{If \code{TRUE}, the annotations for the dataset
are checked using \code{is.genalex(x, force = TRUE, skip.strings = TRUE)}
prior to conversion.  If that returns \code{FALSE}, nothing is converted
and an error is generated.}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
\code{x} as a data frame with the genotype of each locus encoded
using  class \code{\link[genetics]{genotype}}.  The class
\code{'genalex'} is removed while many of the attributes are retained:

\item{data.file.name }{The original value, wrapped with
  \code{"as.genetics(...)"}}
\item{ploidy }{Retained}
\item{n.loci }{Retained}
\item{n.samples }{Retained}
\item{n.pops }{Retained}
\item{pop.labels }{Retained}
\item{pop.sizes }{Retained}
\item{dataset.title }{Retained}
\item{sample.title }{Retained}
\item{pop.title }{Retained}
\item{locus.names }{Retained}
\item{locus.columns }{Modified to indicate the change to a single column
  per locus}
\item{extra.columns }{Retained}
}
\description{
Converts an object of class \code{'genalex'} to a data frame in which the
genotype columns for each locus have been converted to genotypes
encoded with class \code{\link[genetics]{genotype}} as provided by the
\href{http://cran.r-project.org/web/packages/genetics/index.html}{genetics}
package.  All class {'genalex'} attributes are retained except for
class \code{'genalex'} itself; see Details.  Only conversion of diploid
data are supported, a inherent limitation of the
\href{http://cran.r-project.org/web/packages/genetics/index.html}{genetics}
package.
}
\details{
A class \code{\link[genetics]{genotype}} object is a special type
of factor, and in contrast to class \code{'genalex'} a diploid genotype
is encoded as a single level of a factor and thus is in a single column
of a data frame. For diploid data, the number of columns in the resulting
data frame will be reduced by the number of loci.  The sample name and
population columns are retained, as are the names of the loci.

If either allele of a genotype is missing, the entire genotype is treated
as missing in class \code{\link[genetics]{genotype}}.

This is a specialised wrapper around the functions
\code{\link[genetics]{makeGenotypes}} (\code{phased = FALSE}) and
\code{\link[genetics]{makeHaplotypes}} (\code{phased = TRUE}) from the
\href{http://cran.r-project.org/web/packages/genetics/index.html}{genetics}
package.
}
\examples{
data(Qagr_pericarp_genotypes)
dd <- as.genalex(head(Qagr_pericarp_genotypes, 40), force = TRUE)
as.genetics(dd)
}
\author{
Douglas G. Scofield
}
\seealso{
\code{\link[genetics]{genotype}}, \code{\link[genetics]{haplotype}}, \code{\link[genetics]{makeGenotypes}}, \code{\link[genetics]{makeHaplotypes}}
}

