#' Coast live oak (Quercus agrifolia) adult microsatellite genotypes
#'
#' This data set contains one annotated data frame of class \code{'genalex'},
#' holding 10-locus diploid microsatellite genotypes of 262 adult coast live
#' oak (\emph{Quercus agrifolia}) trees from Sedgwick Reserve, Santa Barbara
#' County, California, USA.
#'
#' These data have been analysed in several published papers, and are also
#' publicly available at the Dryad Digital Repository.  If using these data,
#' please cite the original paper as well as the data, as shown below.
#'
#' @format Annotated data frames of class \code{'genalex'}.  Columns are:
#' \tabular{ll}{
#'   \code{AdultMomFamily} \tab Identifier for adult tree \cr
#'   \code{Site}           \tab Population, always \code{Sedgwick} for this data set \cr
#'   \code{0c11}           \tab First allele for microsatellite locus 0c11 \cr
#'   \code{0c11.2}         \tab Second allele for microsatellite locus 0c11 \cr
#'   \code{\dots}          \tab Remaining 9 microsatellite genotypes \cr
#' }
#' 
#' @source \url{http://datadryad.org/resource/doi:10.5061/dryad.40kq7}
#'
#' @references Scofield DG, Smouse PE, Karubian J, Sork VL (2012) Use of alpha,
#' beta, and gamma diversity measures to characterize seed dispersal by 
#' animals. The American Naturalist 180(6): 719-732. 
#' \url{http://dx.doi.org/10.1086/668202}
#' 
#' Scofield DG, Smouse PE, Karubian J, Sork VL (2012) Data from: Use of alpha,
#' beta, and gamma diversity measures to characterize seed dispersal by animals.
#' Dryad Digital Repository. \url{http://dx.doi.org/10.5061/dryad.40kq7}
#'
#' \url{https://github.com/douglasgscofield/readGenalex}
#'
#' @keywords datasets
#' 
#' @docType data
#' 
#' @name Qagr_adult_genotypes
#' 
NULL



#' Coast live oak (Quercus agrifolia) pericarp microsatellite genotypes
#'
#' This data set contains one annotated data frame of class \code{'genalex'},
#' holding 10-locus diploid microsatellite genotypes of 568 pericarps (outer
#' seed coats) from coast live oak (\emph{Quercus agrifolia}) acorns collected
#' from 17 acorn woodpecker (\emph{Melanerpes formicivorus}) granaries at
#' Sedgwick Reserve, Santa Barbara County, California, USA.
#'
#' These data have been analysed in several published papers, and are also
#' publicly available at the Dryad Digital Repository.  If using these data,
#' please cite the original paper as well as the data, as shown below.
#'
#' @format Annotated data frames of class \code{'genalex'}.  Columns are:
#' \tabular{ll}{
#'   \code{PericarpID} \tab Identifier for sampled pericarp \cr
#'   \code{Granary}    \tab Granary from which the pericarp was collected \cr
#'   \code{0c11}       \tab First allele for microsatellite locus 0c11 \cr
#'   \code{0c11.2}     \tab Second allele for microsatellite locus 0c11 \cr
#'   \code{\dots}      \tab Remaining 9 microsatellite genotypes \cr
#' }
#' 
#' @source \url{http://datadryad.org/resource/doi:10.5061/dryad.40kq7}
#'
#' @references Scofield DG, Smouse PE, Karubian J, Sork VL (2012) Use of alpha,
#' beta, and gamma diversity measures to characterize seed dispersal by 
#' animals. The American Naturalist 180(6): 719-732. 
#' \url{http://dx.doi.org/10.1086/668202}
#' 
#' Scofield DG, Smouse PE, Karubian J, Sork VL (2012) Data from: Use of alpha,
#' beta, and gamma diversity measures to characterize seed dispersal by animals.
#' Dryad Digital Repository. \url{http://dx.doi.org/10.5061/dryad.40kq7}
#'
#' \url{https://github.com/douglasgscofield/readGenalex}
#'
#' @keywords datasets
#' 
#' @docType data
#' 
#' @name Qagr_pericarp_genotypes
#' 
NULL
