% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{slate}
\alias{slate}
\title{Theme slate}
\usage{
slate(
  font_family = "Arial",
  font_size = 15,
  font_color = "#aaaaaa",
  header_font_family = "Arial",
  header_font_size = 16,
  header_font_color = "#97999b",
  cell_padding = 6
)
}
\arguments{
\item{font_family}{Font family for the text within the table.
Default is Arial.}

\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #aaaaaa.}

\item{header_font_family}{Font family for the header text.
Default is Arial.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 16.}

\item{header_font_color}{Color of the font for the header text.
Default is #97999b.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Bootstrap-inspired slate theme
}
\examples{
data <- iris[10:29, ]

## Standard slate theme
reactable(data,
          theme = slate())

## Cerulean theme with additional options applied
reactable(data,
          theme = slate(font_size = 12, font_color = "grey", cell_padding = 3))

}
