% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_tiles.R
\name{color_tiles}
\alias{color_tiles}
\title{Add color tiles to rows in a column}
\usage{
color_tiles(
  data,
  colors = c("#ff3030", "#ffffff", "#1e90ff"),
  number_fmt = NULL,
  bright_values = TRUE,
  span = FALSE
)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{colors}{A vector of colors to color the cells.
Colors should be given in order from low values to high values.
Default colors provided are red-white-blue: c("#ff3030", "#ffffff", "#1e90ff").
Can use R's built-in colors or other color packages.}

\item{number_fmt}{Optionally format numbers using formats from the scales package.
Default is set to NULL.}

\item{bright_values}{Optionally display values as white.
Values with a dark-colored background will be shown in white.
Default is set to TRUE but can be turned off by setting to FALSE.}

\item{span}{Optionally apply colors to values across multiple columns instead of by each column.
To apply across all columns set to TRUE.
If applying to a set of columns, can provide either column names or column positions.
Default is set to FALSE.}
}
\value{
a function that applies conditional color tiles
    to a column of numeric values.
}
\description{
The `color_tiles()` function conditionally colors the background of each cell similarly to color_scales().
    The difference is that color_tiles() uses round colored tiles around values instead of the entire background of the cell.
    Another difference is color_tiles() allows number formatting with number_fmt whereas color_scales() does not.
    The last difference is it needs to placed within the cell argument in reactable::colDef vs the style argument for color_scales().
}
\examples{
data <- iris[10:29, ]

## By default, the colors_tiles() function uses a red-white-blue three-color pattern
reactable(data,
 columns = list(
 Petal.Length = colDef(cell = color_tiles(data))))

## If only two colors are desired,
## you can specify them with colors = 'c(color1, color2)';
reactable(data,
 columns = list(
 Petal.Length = colDef(cell = color_tiles(data,
 colors = c("red", "green")))))

## Use span to apply colors to values in relation to the entire dataset
reactable(data,
defaultColDef = colDef(cell = color_tiles(data, span = TRUE)))

## Use number_fmt to format numbers using the scales package
car_prices <- MASS::Cars93[20:49, c("Make", "Price")]

reactable(car_prices,
defaultColDef = colDef(cell = color_tiles(car_prices,
number_fmt = scales::dollar)))

## Use span to apply colors to values in relation to the entire dataset
reactable(data,
defaultColDef = colDef(cell = color_tiles(data, span = TRUE)))

## Span can take column names
reactable(data,
defaultColDef = colDef(cell = color_tiles(data, span = c("Sepal.Length", "Sepal.Width"))))

## Or it can also take column positions instead
reactable(data,
defaultColDef = colDef(cell = color_tiles(data, span = 1:2)))

}
