% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{basebind}
\alias{basebind}
\title{Function used to combine baseline functions in one plot}
\usage{
basebind(..., legend.title, legend.labels, control = list())
}
\arguments{
\item{...}{\code{ggplot} objects created by plotting \code{reReg} objects.}

\item{legend.title}{an optional character string to specify the legend title.}

\item{legend.labels}{an optional character string to specify the legend labels.}

\item{control}{a list of control parameters.}
}
\description{
Combine different plots into one.
}
\examples{
data(simDat)
fm <- Recur(t.stop, id, event, status) ~ x1 + x2
fit1 <- reReg(fm, subset = x1 == 0, data = simDat, B = 200)
fit2 <- reReg(fm, subset = x1 == 1, data = simDat, B = 200)
basebind(plot(fit1), plot(fit2))
}
\keyword{Plots}
