% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_to_raster.R
\name{coord_to_raster}
\alias{coord_to_raster}
\title{Turn coordinates of outlets into rasters}
\usage{
coord_to_raster(outlet, out, overwrite = FALSE)
}
\arguments{
\item{outlet}{A single pair of Easting, Northing or long, lat coordinates as a numeric vector.}

\item{out}{The file name of the output outlet raster in the current GRASS mapset.}

\item{overwrite}{Whether the output files should be allowed to overwrite existing files. Defaults to \code{FALSE}.}
}
\value{
Nothing.
}
\description{
Given a set of coordinates in space (x, y), this function will return a rasterised version of that point in space.
}
\examples{
# Will only run if GRASS is running
if(check_running()){
# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")

# Set environment parameters
set_envir(dem)

# Read in data
raster_to_mapset(dem)

# Set coordinates to rasterise
coord_df <-  c(1098671, 6924794)

# Convert to raster
coord_to_raster(outlet = coord_df, out = "coords", overwrite = TRUE)

# Plot
plot_GRASS("dem.tif", col = topo.colors(15))
plot_GRASS("coords", col = "red", add = TRUE)
}
}
