
#' drop_dir
#'
#'Retrieves file and folder metadata.
#'
#' A sample output for contents returns the following fields:
#' size, rev, thumb_exists, bytes, modified, client_mtime, path, is_dir, icon, root, mime_type, revision. Note that
#' with verbose set to FALSE you only get a subset of these fields. To get the full output, look in \code{drop_dir()$contents}
#' @template path
#' @template file_limit
#' @param  hash  Each call to /metadata on a folder will return a hash field, generated by hashing all of the metadata contained in that response. On later calls to /metadata, you should provide that value via this parameter so that if nothing has changed, the response will be a 304 (Not Modified) status code instead of the full, potentially very large, folder listing. This parameter is ignored if the specified path is associated with a file or if list=false.
#' @param  list  The strings true and false are valid values. true is the default. If true, the folder's metadata will include a contents field with a list of metadata entries for the contents of the folder. If false, the contents field will be omitted.
#' @param  include_deleted Only applicable when list is set. If this parameter is set to true, then contents will include the metadata of deleted children. Note that the target of the metadata call is always returned even when it has been deleted (with is_deleted set to true) regardless of this flag.
#' @param  rev If you include a particular revision number, then only the metadata for that revision will be returned.
#' @template locale
#' @param include_media_info   If true, each file will include a photo_info dictionary for photos and a video_info dictionary for videos with additional media info. If the data isn't available yet, the string pending will be returned instead of a dictionary.
#' @template include_membership
#' @template verbose
#' @template token
#' @export
#' @examples \dontrun{
#' drop_dir()
#'}
drop_dir <- function(path = NULL,
                    file_limit = 10000,
                    hash = NULL,
                    list = TRUE,
                    include_deleted = FALSE,
                    rev = NULL,
                    locale = NULL,
                    include_media_info = TRUE,
                    include_membership = FALSE,
                    verbose = FALSE,
                    dtoken = get_dropbox_token()) {
  is_dir <- NULL
  args <- as.list(drop_compact(c(file_limit = file_limit,
                  hash = hash,
                  list = list,
                  include_deleted = include_deleted,
                  rev = rev,
                  locale = locale,
                  include_media_info = include_media_info,
                  include_membership = include_membership)))
  metadata_url <- "https://api.dropbox.com/1/metadata/auto/"
  if(!is.null(path)) {
        metadata_url <- paste0(metadata_url, path)
  }
  req <- httr::GET(metadata_url, query = args, config(token = get_dropbox_token()))
  res <- jsonlite::fromJSON(httr::content(req, as = "text"), flatten = TRUE)
  if(length(res$contents) > 0) { # i.e. not an empty folder
  if(verbose) {
    res2 <- res
    res2$contents <- NULL
    res$contents <- dplyr::tbl_df(res$contents)
    pretty_lists(res2)
    print(dplyr::tbl_df(res$contents))
    invisible(res)
  } else {

    path <- mime_type <- root <- bytes <- modified <- NULL
    if("mime_type" %in% names(res$contents)) {
    dplyr::tbl_df(res$contents) %>% dplyr::select(path, mime_type, root, bytes, modified)
    } else {
      dplyr::tbl_df(res$contents) %>% dplyr::select(path, is_dir, root, bytes, modified)
    }
  }
  } else {
    NULL
  }
}
# TODO
# Summarize total file sizes etc





