% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relativeentropy.R
\docType{methods}
\name{relativeentropy}
\alias{relativeentropy}
\alias{is.relativeentropy}
\alias{show,relativeentropy-method}
\title{Calculate relative entropy}
\usage{
relativeentropy(results, meta, tag)

is.relativeentropy(x)

\S4method{show}{relativeentropy}(object)
}
\arguments{
\item{results}{\code{matrix} of mode \code{numeric}; contains values 
calculated from diversity-term functions \code{raw_beta()} and 
\code{norm_beta()}}

\item{meta}{object of class \code{metacommunity}}

\item{tag}{measure}

\item{x}{any R object}

\item{object}{object of class \code{relativeentropy}}
}
\value{
object of class \code{relativeentropy}

\code{is.relativeentropy(x)} returns TRUE if its argument is a 
relativeentropy, FALSE otherwise.
}
\description{
Functions to check if an object is a \code{relativeentropy}, or coerse an  
object into a \code{relativeentropy}; for \code{raw_beta()} or 
\code{norm_beta()}.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate raw subcommunity beta diversity
a <- raw_beta(meta)
class(a)

}
