% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powermean.R
\docType{methods}
\name{powermean}
\alias{powermean}
\alias{is.powermean}
\alias{show,powermean-method}
\title{Calculate power mean}
\usage{
powermean(results, meta, tag)

is.powermean(x)

\S4method{show}{powermean}(object)
}
\arguments{
\item{results}{\code{matrix} of mode \code{numeric}; contains values 
calculated from diversity-term functions \code{norm_alpha()}, 
\code{raw_alpha()}, \code{raw_rho()}, \code{norm_rho()}, and 
\code{raw_gamma()}}

\item{meta}{object of class \code{metacommunity}; contains proportional
abundance of types, pair-wise similarity, and other associated variables.}

\item{tag}{measure}

\item{x}{any R object}

\item{object}{object of class \code{powermean}}
}
\value{
\code{powermean(x)} returns an object of class \code{powermean}.

\code{is.powermean(x)} returns TRUE if its argument is a
powermean, FALSE otherwise.

\code{print(x)} prints an object object of class \code{powermean}
}
\description{
Functions to check if an object is a \code{powermean}, or coerse an object 
into a \code{powermean}; for \code{raw_alpha()}, \code{norm_alpha()}, 
\code{raw_rho()}, \code{norm_rho()}, or  \code{raw_gamma()}.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate subcommunity raw alpha diversity (takes the powermean)
a <- raw_alpha(meta)
class(a)

}
