% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacommunity.R
\docType{methods}
\name{metacommunity}
\alias{metacommunity}
\alias{metacommunity,data.frame,missing-method}
\alias{metacommunity,data.frame-method}
\alias{metacommunity,numeric,missing-method}
\alias{metacommunity,numeric-method}
\alias{metacommunity,matrix,missing-method}
\alias{metacommunity,matrix-method}
\alias{metacommunity,data.frame,matrix-method}
\alias{metacommunity,data.frame-method,matrix-method}
\alias{metacommunity,numeric,matrix-method}
\alias{metacommunity,numeric-method,matrix-method}
\alias{metacommunity,matrix,matrix-method}
\alias{metacommunity,matrix-method}
\alias{metacommunity,missing,phylo-method}
\alias{metacommunity,phylo-method}
\alias{metacommunity,numeric,phylo-method}
\alias{metacommunity,numeric-method,phylo-method}
\alias{metacommunity,data.frame,phylo-method}
\alias{metacommunity,data.frame-method,phylo-method}
\alias{metacommunity,matrix,phylo-method}
\alias{metacommunity,matrix-method,phylo-method}
\title{Coerce to metacommunity}
\usage{
metacommunity(partition, similarity, ...)

\S4method{metacommunity}{data.frame,missing}(partition)

\S4method{metacommunity}{numeric,missing}(partition)

\S4method{metacommunity}{matrix,missing}(partition)

\S4method{metacommunity}{data.frame,matrix}(partition, similarity)

\S4method{metacommunity}{numeric,matrix}(partition, similarity)

\S4method{metacommunity}{matrix,matrix}(partition, similarity)

\S4method{metacommunity}{missing,phylo}(partition, similarity, interval = 1)

\S4method{metacommunity}{numeric,phylo}(partition, similarity, interval = 1)

\S4method{metacommunity}{data.frame,phylo}(partition, similarity,
  interval = 1)

\S4method{metacommunity}{matrix,phylo}(partition, similarity, interval = 1)
}
\arguments{
\item{partition}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types, columns as subcommunities, and elements containing  
the relative abundances of types in subcommunities. For phylogenetic 
diversity, see \emph{Details}.}

\item{similarity}{(optional) two-dimensional \code{matrix} of mode 
\code{numeric}, with rows as types, columns as types, and elements 
containing the pairwise similarity between \emph{types}. For phylogenetic 
diversity, see \emph{Details}.}

\item{...}{(optional) additional arguments, especially:}

\item{interval}{(optional; and for phylogenetic metacommunities only) how
much evolutionary history should be retained, with 0 marking the most
recent present-day species, and 1 (the default) marking the most recent 
common ancestor. Numbers greater than 1 extend the root of the tree.}
}
\value{
Returns an object of class \code{metacommunity} (see \emph{Details}).
}
\description{
Functions to check if an object is a \code{metacommunity} or coerce an
object into a \code{metacommunity}.
}
\details{
\itemize{
\item type_abundance - proportional abundance of \emph{types} in the  
subcommunity as a fraction of the metacommunity as a whole (in the 
phylogenetic case, this corresponds to the proportional abundance of 
historical species, which is calculated from the proportional abundance of 
present day species)
\item similarity - pairwise similarity between \emph{types}
\item ordinariness - ordinariness of types 
\item subcommunity_weights - subcommunity weights
\item type_weights - weight of types within a subcommunity
\item raw_abundance - proportional abundance of samples (usually types, 
except in the phylogenetic case where samples correspond to the present 
day species)
\item raw_structure - length of historical species (in phylogeny)
\item parameters - parameters associated with each 
historical species (in phylogeny)
}

When calculating phylogenetic diversity either:
\itemize{
\item set \code{partition} as the relative abundance of present-day species,  
with \code{similarity} as an object of class \code{phylo}, from which the 
relative abundance and pairwise similarity of historical species will be
calculated; or
\item set \code{partition} as the relative abundance of historical species,
with \code{similarity} as the pairwise similarity of historical species.
}
}
\examples{
tree <- ape::rtree(n = 5)
tree$tip.label <- paste0("sp", seq_along(tree$tip.label))
partition <- cbind(a = c(1,1,1,0,0), b = c(0,1,0,1,1))
row.names(partition) <- tree$tip.label
partition <- partition / sum(partition)

a <- metacommunity(partition, tree)
b <- metacommunity(partition)

}
\seealso{
\code{\link{metacommunity-class}}
}
