% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chainsaw.R
\name{chainsaw}
\alias{chainsaw}
\title{Cut Phylogeny}
\usage{
chainsaw(partition, ps, interval, depth)
}
\arguments{
\item{partition}{proportional abundance of \emph{types} in the
subcommunity as a fraction of the metacommunity as a whole (in the
phylogenetic case, this corresponds to the proportional abundance of
terminal taxa).}

\item{ps}{\code{phy_struct()} output.}

\item{interval}{proportion of total tree height to be conserved (taken as
a proportion from the heighest tip). Describes how far back we go in the tree,
with 0 marking the date of the most recent tip, and 1 (the default) marking
the most recent common ancestor. Numbers greater than 1 extend the root of
the tree.}

\item{depth}{object length of total tree height to be conserved.}
}
\value{
Returns an object of class \code{phy_struct} containing a new structural
matrix ('@structure').and the original phylogenetic parameters
('@parameters').
}
\description{
Cut Phylogeny
}
\examples{
tree <- ape::rtree(n = 5)
tree$tip.label <- paste0("sp", seq_along(tree$tip.label))
partition <- cbind(a = c(1,1,1,0,0), b = c(0,1,0,1,1))
row.names(partition) <- tree$tip.label
partition <- partition / sum(partition)
ps <- phy_struct(tree, partition)

a <- chainsaw(partition, ps, interval = 0.9)
b <- chainsaw(partition, ps, interval = 2)
z <- chainsaw(partition, ps, interval = 0)
m <- chainsaw(partition, ps, interval = 1)

}
