% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_datasets.R
\name{read_zipdata}
\alias{read_zipdata}
\title{Read filetype from a zipped folder based on the file ending}
\usage{
read_zipdata(zfile, pattern = ".dta$", readfn = haven::read_dta, ...)
}
\arguments{
\item{zfile}{Path to `.zip` file containing flat file dataset,
usually ending in filename `XXXXXXFL.zip`}

\item{pattern}{String detailing which filetype is to be read
from within the zip by means of a grep. Default = ".dta$"}

\item{readfn}{Function object to be used for reading in the
identified file within the zip. Default = `haven::read_dta`}

\item{...}{additional arguments to readfn}
}
\description{
Read filetype from a zipped folder based on the file ending
}
\examples{
\dontrun{
# get the model datasets included in the package
model_datasets <- model_datasets

# download just the zip
g <- get_datasets(
dataset_filenames = model_datasets$FileName[1],
download_option = "zip"
)

# and then read from the zip. This function is used internally by rdhs
# when using `get_datasets` with `download_option = .rds` (default)
r <- read_zipdata(
g[[1]], pattern = ".dta"
)

# and we can pass a function to read the file and any other args with ...
r <- read_zipdata(
g[[1]], pattern = ".dta", readfn = haven::read_dta, encoding = "UTF-8"
)
}
}
