% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_endpoints.R
\name{dhs_info}
\alias{dhs_info}
\title{API request of DHS Info}
\usage{
dhs_info(
  infoType = NULL,
  f = NULL,
  returnFields = NULL,
  perPage = NULL,
  page = NULL,
  client = NULL,
  force = FALSE,
  all_results = TRUE
)
}
\arguments{
\item{infoType}{Specify a type of info to obtain the information requested.
Default is version. `infoType="version"`` (default) Provides the version
of the API.
Example: https://api.dhsprogram.com/rest/dhs/info?infoType=version
`infoType="citation"` Provides the citation for the API to include with
your application or data.
Example: https://api.dhsprogram.com/rest/dhs/info?infoType=citation}

\item{f}{You can specify the format of the data returned from the query as
HTML, JSON, PJSON, geoJSON, JSONP, XML or CSV. The default data format
is JSON.}

\item{returnFields}{Specify a list of attributes to be returned.}

\item{perPage}{Specify the number of results to be returned per page. By
default the API will return 100 results.}

\item{page}{Allows specifying a page number to obtain for the API request. By
default the API will return page 1.}

\item{client}{If the API request should be cached, then provide a client
object created by \code{\link{client_dhs}}}

\item{force}{Should we force fetching the API results, and ignore any
cached results we have. Default = FALSE}

\item{all_results}{Boolean for if all results should be returned. If FALSE
then the specified page only will be returned. Default = TRUE.}
}
\value{
Returns a \code{data.table} of 2 (or less if \code{returnFields} is provided)
  fields describing the type of information that was requested and a value
  corresponding to the information requested.
  \url{https://api.dhsprogram.com/rest/dhs/info/fields}
}
\description{
API request of DHS Info
}
\examples{

\dontrun{
# The main use for the info API  will be to confirm the version of the API
# being used to providing the most current citation for the data.

dat <- dhs_info(infoType="version")

# A complete list of examples for how each argument to the info API
# endpoint can be provided is given below, which is a copy of each of
# the examples listed in the API at:

# https://api.dhsprogram.com/#/api-info.cfm


dat <- dhs_info(infoType="version",all_results=FALSE)
dat <- dhs_info(infoType="citation",all_results=FALSE)
dat <- dhs_info(f="html",all_results=FALSE)
}
}
