% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhs_flat.R
\name{parse_meta}
\alias{parse_meta}
\alias{parse_dcf}
\alias{parse_sps}
\alias{parse_do}
\title{Parse fixed-width file metadata}
\usage{
parse_dcf(dcf, all_lower = TRUE)

parse_sps(sps, all_lower = TRUE)

parse_do(do, dct, all_lower = TRUE)
}
\arguments{
\item{dcf}{.DCF file path to parse}

\item{all_lower}{logical indicating whether to convert variable labels to
lower case. Defaults to `TRUE`.}

\item{sps}{.SPS file as character vector (e.g. from readLines)}

\item{do}{.DO file as character vector (e.g. from readLines)}

\item{dct}{.DCT file as character vector (e.g. from readLines)}
}
\value{
data.frame with metadata for parsing fixed-width flat file
}
\description{
Parse dataset metadata
}
\examples{
mrfl_zip <- tempfile()
download.file(
paste0(
"https://dhsprogram.com/customcf/legacy/data/sample_download_dataset.cfm?",
"Filename=ZZMR61FL.ZIP&Tp=1&Ctry_Code=zz&survey_id=0&doctype=dhs"),
mrfl_zip, mode="wb"
)

dcf <- rdhs::read_zipdata(mrfl_zip, "\\\\.DCF", readLines)
dct <- rdhs:::parse_dcf(dcf)

sps <- rdhs::read_zipdata(mrfl_zip, "\\\\.SPS", readLines)
dct <- rdhs:::parse_sps(sps)

do <- rdhs::read_zipdata(mrfl_zip, "\\\\.DO", readLines)
dctin <- rdhs::read_zipdata(mrfl_zip, "\\\\.DCT", readLines)
dct <- rdhs:::parse_do(do, dctin)

}
