% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomFieldService.R
\name{dfp_getCustomFieldsByStatement}
\alias{dfp_getCustomFieldsByStatement}
\title{getCustomFieldsByStatement}
\usage{
dfp_getCustomFieldsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getCustomFieldsByStatementResponse
}
\description{
Gets a CustomFieldPage of CustomField objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{entityType}
  \item{name}
  \item{isActive}
  \item{visibility}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getCustomFieldsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/CustomFieldService#getCustomFieldsByStatement}{Google Documentation for getCustomFieldsByStatement}
}
