% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfp_auth.R
\name{dfp_auth}
\alias{dfp_auth}
\title{Authorize \code{rdfp}}
\usage{
dfp_auth(token = NULL, new_user = FALSE,
  addtl_scopes = c("https://spreadsheets.google.com/feeds",
  "https://www.googleapis.com/auth/drive",
  "https://www.googleapis.com/auth/spreadsheets",
  "https://www.googleapis.com/auth/presentations",
  "https://www.googleapis.com/auth/analytics",
  "https://www.googleapis.com/auth/yt-analytics.readonly",
  "https://www.googleapis.com/auth/gmail.readonly",
  "https://www.googleapis.com/auth/gmail.compose",
  "https://www.googleapis.com/auth/gmail.send"),
  key = getOption("rdfp.client_id"),
  secret = getOption("rdfp.client_secret"),
  cache = getOption("rdfp.httr_oauth_cache"), verbose = TRUE)
}
\arguments{
\item{token}{an actual token object or the path to a valid token stored as an
\code{.rds} file}

\item{new_user}{logical, defaults to \code{FALSE}. Set to \code{TRUE} if you
want to wipe the slate clean and re-authenticate with the same or different
Google account. This deletes the \code{.httr-oauth} file in current working
directory.}

\item{addtl_scopes}{character, strings that indicate additional Google services 
the client should authorize. Use this when trying to generate a token that will 
work to authenticate to other packages using Google services, such as the googlesheets 
package or RGoogleAnalytics package.}

\item{key, secret}{the "Client ID" and "Client secret" for the application}

\item{cache}{logical indicating if \code{rdfp} should cache
credentials in the default cache file \code{.httr-oauth}}

\item{verbose}{a logical indicating if messages should be printed}
}
\value{
an OAuth token object, specifically a
  \code{\link[=Token-class]{Token2.0}}, invisibly
}
\description{
Authorize \code{rdfp} to access your Google user data. You will be
directed to a web browser, asked to sign in to your Google account, and to
grant \code{rdfp} access to user data for Double Click for Publishers. 
These user credentials are cached in a file named
\code{.httr-oauth} in the current working directory, from where they can be
automatically refreshed, as necessary.
}
\details{
Most users, most of the time, do not need to call this function
explicitly -- it will be triggered by the first action that
requires authorization. Even when called, the default arguments will often
suffice. However, when necessary, this function allows the user to

\itemize{
  \item store a token -- the token is invisibly returned and can be assigned
  to an object or written to an \code{.rds} file
  \item read the token from an \code{.rds} file or pre-existing object in the
  workspace
  \item provide your own app key and secret -- this requires setting up a new
  project in
  \href{https://console.developers.google.com}{Google Developers Console}
  \item prevent caching of credentials in \code{.httr-oauth}
}

In a call to \code{dfp_auth}, the user can provide the token, app key and
secret explicitly and can dictate whether credentials will be cached in
\code{.httr_oauth}. They must be specified.

To set options in a more persistent way, predefine one or more of
them with lines like this in a \code{.Rprofile} file:
\preformatted{
options(rdfp.network_code = "12345678",
        rdfp.application_name = "MyApp",
        rdfp.client_id = "012345678901-99thisisatest99.apps.googleusercontent.com",
        rdfp.client_secret = "Th1s1sMyC1ientS3cr3t",
        rdfp.httr_oauth_cache = FALSE)
}
See \code{\link[base]{Startup}} for possible locations for this file and the
implications thereof.

More detail is available from
\href{https://developers.google.com/identity/protocols/OAuth2}{Using OAuth
2.0 to Access Google APIs}.
}
