
rdfp <img src="man/figures/rdfp.png" width="120px" align="right" />
===================================================================

[![Build Status](https://travis-ci.org/StevenMMortimer/rdfp.svg?branch=master)](https://travis-ci.org/StevenMMortimer/rdfp) [![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/github/StevenMMortimer/rdfp?branch=master&svg=true)](https://ci.appveyor.com/project/StevenMMortimer/rdfp) [![CRAN\_Status\_Badge](http://www.r-pkg.org/badges/version/rdfp)](http://cran.r-project.org/package=rdfp) [![Coverage Status](https://codecov.io/gh/StevenMMortimer/rdfp/branch/master/graph/badge.svg)](https://codecov.io/gh/StevenMMortimer/rdfp?branch=master)

**Compiled using DFP API version: `v201802`**

**rdfp** allows you to use the DoubleClick for Publishers API from R. Manage inventory, create orders, pull reports, and more!

Table of Contents
-----------------

-   [Installation](#installation)
-   [Vignettes](#vignettes)
-   [Usage](#usage)
    -   [Functions](#functions)
    -   [Set API Version](#set-api-version)
    -   [Authenticate](#authenticate)
    -   [Get Current User Info](#get-current-user-info)
    -   [Pull a LineItem](#pull-a-lineitem)
    -   [Run a Report](#run-a-report)
-   [Credits](#credits)
-   [More Information](#more-information)

Installation
------------

``` r
install.packages("devtools")

# or to get the latest version available on GitHub
devtools::install_github("StevenMMortimer/rdfp")
```

If you encounter a clear bug, please file a minimal reproducible example on [GitHub](https://github.com/StevenMMortimer/rdfp/issues).

Vignettes
---------

The README below outlines the package functionality, but review the vignettes for more detailed examples on usage.

-   [Administrative Tasks](https://StevenMMortimer.github.io/rdfp/articles/administrative-tasks.html)
-   [Ad Trafficking Setup](https://StevenMMortimer.github.io/rdfp/articles/ad-trafficking-setup.html)
-   [Manipulating Orders and LineItems](https://StevenMMortimer.github.io/rdfp/articles/manipulating-orders-and-lineitems.html)
-   [Checking Availability](https://StevenMMortimer.github.io/rdfp/articles/checking-availability.html)
-   [Pulling Reports](https://StevenMMortimer.github.io/rdfp/articles/pulling-reports.html)

Usage
-----

### Functions

All functions start with `dfp_` so that you can easily identify DFP-specific operations and use tab completion in RStudio. Most **rdfp** functions will return a `data.frame` or `list` parsed from the XML returned in the SOAP response.

### Load Package and Set API Version

Google releases 4 versions of the DFP API each year and deprecates versions older than one year, so there is a lot that's regularly changing in this package. **rdfp** is periodically compiled against a recent version of the API. If you would like to use an older or newer API version that what is the package default, then just specify it as an option.

``` r
library(rdfp)
# see the package default version
getOption("rdfp.version")
#> [1] "v201802"
# this will force all calls to be against the version "v201711"
options(rdfp.version = "v201711")
```

### Authenticate

To authenticate you will first need to specify the `network_code` of the DFP instance you'd like to connect to. This is the only required option that the user must specify when using the **rdfp** package. After setting the `network_code` all you need to do is run `dfp_auth()`. If you already have a cached `.httr-oauth` file in the current working directory, then the token will be loaded and refreshed if necessary. Otherwise, your browswer will pop open and you will interactively authenticate.

The package has other options like a client\_id and client\_secret where you can connect using your own API client instead of the package default. Using your own client requires setting one up in the \[Google Developers Console\] (<https://console.developers.google.com>).

``` r
options(rdfp.network_code = "12345678")
options(rdfp.application_name = "MyApp")
options(rdfp.client_id = "012345678901-99thisisatest99.apps.googleusercontent.com")
options(rdfp.client_secret = "Th1s1sMyC1ientS3cr3t")

# this function will use the options set above and 
# cache an OAuth token in the working directory
# the token will be refreshed when necessary
dfp_auth()
```

### Get Current User Info

``` r
# Check current user or network
user_info <- dfp_getCurrentUser()
user_info[,c('id', 'isActive')]
#> # A tibble: 1 x 2
#>           id isActive
#>        <dbl> <chr>   
#> 1 185549536. true
network_info <- dfp_getCurrentNetwork()
network_info[,c('id', 'networkCode')]
#> # A tibble: 1 x 2
#>        id networkCode
#>     <dbl>       <dbl>
#> 1 109096.    1019096.
```

#### Pull a LineItem

The function `dfp_getLineItemsByStatement()` function from the [LineItemService](https://developers.google.com/doubleclick-publishers/docs/reference/v201802/LineItemService) allows you to retrieve Line Items by Publishers Query Language (PQL) statement. The statement is constructed as a list of lists that are nested to emulate the hierarchy of the XML that needs to be created in the request.

``` r
# Retrieve up to 3 Line Items that have a status of "DELIVERING"
request_data <- list('filterStatement'=list('query'="WHERE status='DELIVERING' LIMIT 3"))
resultset <- dfp_getLineItemsByStatement(request_data, as_df=TRUE) 
resultset[,c('orderId', 'id', 'priority', 'deliveryRateType')]
#> # A tibble: 3 x 4
#>       orderId          id priority deliveryRateType
#>         <dbl>       <dbl>    <dbl> <chr>           
#> 1 1254227776. 1928427256.      12. EVENLY          
#> 2 1393728736. 2038280896.      12. EVENLY          
#> 3 1265251936. 2060032216.      16. EVENLY
```

### Run a Report

Below is an example of how to make a simple report request.

``` r
# In order to run a report you must specify how the report should be structured 
# by specifying a reportQuery inside a reportJob. All of the dimensions, columns, 
# date range options, etc. are documented at:
# https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ReportService.ReportQuery
request_data <- list(reportJob=list(reportQuery=list(dimensions='MONTH_AND_YEAR', 
                                                     dimensions='AD_UNIT_ID',
                                                     adUnitView='FLAT',
                                                     columns = 'AD_SERVER_IMPRESSIONS', 
                                                     columns = 'AD_SERVER_CLICKS',
                                                     dateRangeType='LAST_WEEK'
                                                     )))

# a convenience function has been provided to you to manage the report process workflow
# if you would like more control, see the example below which moves through each step in the process
report_data <- dfp_full_report_wrapper(request_data)
report_data[,c('Dimension.MONTH_AND_YEAR', 'Dimension.AD_UNIT_ID', 'Column.AD_SERVER_CLICKS')]
#> # A tibble: 25 x 3
#>    Dimension.MONTH_AND_YEAR Dimension.AD_UNIT_ID Column.AD_SERVER_CLICKS
#>    <chr>                                   <dbl>                   <dbl>
#>  1 2018-03                            133765096.                   1778.
#>  2 2018-03                            133765216.                    422.
#>  3 2018-03                            133765336.                    642.
#>  4 2018-03                            133765456.                   2176.
#>  5 2018-03                            142461136.                     91.
#>  6 2018-03                            133765576.                  17581.
#>  7 2018-03                            133765696.                    945.
#>  8 2018-03                            133765936.                  18171.
#>  9 2018-03                            142461016.                    312.
#> 10 2018-03                            143543776.                   1496.
#> # ... with 15 more rows
```

Credits
-------

This application uses other open source software components. The authentication components are mostly verbatim copies of the routines established in the **googlesheets** package (<https://github.com/jennybc/googlesheets>). We acknowledge and are grateful to these developers for their contributions to open source.

More Information
----------------

Google provides support for client libraries [here](https://developers.google.com/doubleclick-publishers/docs/clients), but unfortunately, R is not a supported language. Google's client libraries directly reference the production WSDLs to interact with the API, but this package makes SOAP requests best formatted to match the WSDL standards. This articulation is not perfect and continued progress will be made to bring functionality up to par with the client libraries.

Most all operations supported by the DFP API are available via this package. It is strongly recommended that you use the [DFP API Reference](https://developers.google.com/doubleclick-publishers/docs/rel_notes) when using this package. Details on formatting, attributes, and methods are all better explained by Google's documentation.

More information is also available on the `pkgdown` site at <https://StevenMMortimer.github.io/rdfp/>.

[Top](#rdfp-)

------------------------------------------------------------------------

Please note that this project is released with a [Contributor Code of Conduct](CONDUCT.md). By participating in this project you agree to abide by its terms.
