% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GammaModVar.R
\docType{class}
\name{GammaModVar}
\alias{GammaModVar}
\title{A model variable whose uncertainty follows a Gamma distribution}
\description{
An R6 class for a model variable with Gamma uncertainty.
}
\details{
A model variable for which the uncertainty in the point estimate can
be modelled with a Gamma distribution. The hyperparameters of the
distribution are the shape (\code{k}) and the scale (\code{theta}). Note
that although Briggs \emph{et al} (2006) use the shape, scale formulation,
they use \code{alpha}, \code{beta} as parameter names. Inherits from
class \code{ModVar}.
}
\note{
The Gamma model variable class can be used to model the uncertainty of
the mean of a count quantity which follows a Poisson distribution. The Gamma
distribution is the conjugate prior of a Poisson distribution, and the shape
and scale relate directly to the number of intervals from which the mean
count has been estimated. Specifically, the shape (\eqn{k}) is equal to the 
total count of events in \eqn{1/\theta} intervals, where \eqn{\theta} is the
scale. For example, if 200 counts were observed in a sample of 100 intervals, 
setting \code{shape=200} and \code{scale=1/100} gives a Gamma distribution 
with a mean of 2 and a 95\% confidence interval from 1.73 to 2.29.
}
\references{
{
  Briggs A, Claxton K, Sculpher M. Decision modelling for health
  economic evaluation. Oxford, UK: Oxford University Press; 2006. 
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:ModVar]{rdecision::ModVar}} -> \code{GammaModVar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GammaModVar$new()}}
\item \href{#method-is_probabilistic}{\code{GammaModVar$is_probabilistic()}}
\item \href{#method-clone}{\code{GammaModVar$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="SD">}\href{../../rdecision/html/ModVar.html#method-SD}{\code{rdecision::ModVar$SD()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="description">}\href{../../rdecision/html/ModVar.html#method-description}{\code{rdecision::ModVar$description()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="distribution">}\href{../../rdecision/html/ModVar.html#method-distribution}{\code{rdecision::ModVar$distribution()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="get">}\href{../../rdecision/html/ModVar.html#method-get}{\code{rdecision::ModVar$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="is_expression">}\href{../../rdecision/html/ModVar.html#method-is_expression}{\code{rdecision::ModVar$is_expression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mean">}\href{../../rdecision/html/ModVar.html#method-mean}{\code{rdecision::ModVar$mean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mode">}\href{../../rdecision/html/ModVar.html#method-mode}{\code{rdecision::ModVar$mode()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="quantile">}\href{../../rdecision/html/ModVar.html#method-quantile}{\code{rdecision::ModVar$quantile()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="r">}\href{../../rdecision/html/ModVar.html#method-r}{\code{rdecision::ModVar$r()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="set">}\href{../../rdecision/html/ModVar.html#method-set}{\code{rdecision::ModVar$set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="units">}\href{../../rdecision/html/ModVar.html#method-units}{\code{rdecision::ModVar$units()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of class \code{GammaModVar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$new(description, units, shape, scale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{A character string describing the variable.}

\item{\code{units}}{Units of the variable, as character string.}

\item{\code{shape}}{shape parameter of the Gamma distribution.}

\item{\code{scale}}{scale parameter of the Gamma distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{GammaModVar}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic, i.e. a random
variable that follows a distribution, or an expression involving
random variables, some of which follow distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if probabilistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
