% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bw_ik.R
\name{rdd_bw_ik}
\alias{rdd_bw_ik}
\title{Imbens-Kalyanaraman Optimal Bandwidth Calculation}
\usage{
rdd_bw_ik(rdd_object, kernel = c("Triangular", "Uniform", "Normal"))
}
\arguments{
\item{rdd_object}{of class rdd_data created by \code{\link{rdd_data}}}

\item{kernel}{The type of kernel used: either \code{triangular} or \code{uniform}.}
}
\value{
The optimal bandwidth
}
\description{
Imbens-Kalyanaraman optimal bandwidth
for local linear regression in Regression discontinuity designs.
}
\examples{
data(house)
rd<- rdd_data(x=house$x, y=house$y, cutpoint=0)
rdd_bw_ik(rd)
}
\author{
Matthieu Stigler <\email{Matthieu.Stigler@gmail.com}>
}
\references{
Imbens, Guido and Karthik Kalyanaraman. (2012) 'Optimal Bandwidth Choice for the regression discontinuity estimator,'
Review of Economic Studies (2012) 79, 933-959
}
\seealso{
\code{\link{rdd_bw_rsw}} Global bandwidth selector of Ruppert, Sheather and Wand (1995)
}

