% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_citation_count.r
\name{cr_citation_count}
\alias{cr_citation_count}
\title{Get a citation count via CrossRef OpenURL}
\usage{
cr_citation_count(doi, url = "http://www.crossref.org/openurl/",
  key = "cboettig@ropensci.org", ...)
}
\arguments{
\item{doi}{(character) digital object identifier for an article}

\item{url}{(character) the url for the function (should be left to default)}

\item{key}{your Crossref OpenURL email address, either enter, or loads 
from \code{.Rprofile}. We use a default, so you don't need to pass this.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
single numeric value - the citation count, or NA if not found or
no count available
}
\description{
Get a citation count via CrossRef OpenURL
}
\details{
See \url{http://labs.crossref.org/openurl/} for more info on this
		Crossref API service.
}
\examples{
\dontrun{
cr_citation_count(doi="10.1371/journal.pone.0042793")
cr_citation_count(doi="10.1016/j.fbr.2012.01.001")
# DOI not found
cr_citation_count(doi="10.1016/j.fbr.2012")
}
}
\author{
Carl Boettiger \email{cboettig@gmail.com}
}
\seealso{
\code{\link{cr_search}}, \code{\link{cr_r}}
}

