% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdmurl.R
\name{as.tdmurl}
\alias{as.tdmurl}
\alias{as.tdmurl.character}
\alias{as.tdmurl.tdmurl}
\title{Coerce a url to a tdmurl with a specific type}
\usage{
as.tdmurl(url, type, doi)

\method{as.tdmurl}{tdmurl}(url, type, doi)

\method{as.tdmurl}{character}(url, type, doi = NULL)
}
\arguments{
\item{url}{A URL.}

\item{type}{A document type, one of xml, pdf, or plain}

\item{doi}{A DOI, optional, defaults to \code{NULL}}
}
\description{
Coerce a url to a tdmurl with a specific type
}
\examples{
\dontrun{
as.tdmurl("http://downloads.hindawi.com/journals/bmri/2014/201717.xml", 
   "xml")
as.tdmurl("http://downloads.hindawi.com/journals/bmri/2014/201717.pdf", 
   "pdf")
out <- as.tdmurl("http://downloads.hindawi.com/journals/bmri/2014/201717.pdf", 
   "pdf", "10.1155/2014/201717")
attributes(out)
}
}

