% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cr_journals.r
\name{cr_journals}
\alias{cr_journals}
\title{Search CrossRef journals}
\usage{
cr_journals(issn = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  works = FALSE, .progress = "none", ...)
}
\arguments{
\item{issn}{One or more ISSN's. Format is XXXX-XXXX.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter,
the rows and offset parameters are ignored.}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed,
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{works}{(logical) If TRUE, works returned as well, if not then not.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", "tk", "win,
and "time".  See \code{\link[plyr]{create_progress_bar}} for details of each.}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}
}
\description{
Search CrossRef journals
}
\details{
BEWARE: The API will only work for CrossRef DOIs.

Note that some parameters are ignored unless \code{works=TRUE}: sample, sort,
order, filter
}
\examples{
\dontrun{
cr_journals(issn="2167-8359")
cr_journals()
cr_journals(issn="2167-8359", works=TRUE)
cr_journals(issn=c('1803-2427','2326-4225'))
cr_journals(query="ecology")
cr_journals(issn="2167-8359", query='ecology', works=TRUE, sort='score', order="asc")
cr_journals(issn="2167-8359", query='ecology', works=TRUE, sort='score', order="desc")
cr_journals(issn="2167-8359", works=TRUE, filter=c(from_pub_date='2014-03-03'))
cr_journals(query="peerj")
cr_journals(issn='1803-2427', works=TRUE)
cr_journals(issn='1803-2427', works=TRUE, sample=1)
cr_journals(limit=2)

# fails, if you want works, you must give an ISSN
# cr_journals(query = "ecology", filter=c(has_full_text = TRUE), works = TRUE)
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

