% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{filter_clusters}
\alias{filter_clusters}
\title{Cluster the river crossings and select the shortest crossing per cluster}
\usage{
filter_clusters(crossings, river, eps = 100)
}
\arguments{
\item{crossings}{Crossing edge geometries as a simple feature object}

\item{river}{The river geometry as a simple feature object}

\item{eps}{DBSCAN parameter referring to the size (radius) distance of the
neighborhood. Should approximate the distance between edges that we want
to consider as a single river crossing}
}
\value{
A simple feature geometry including the shortest edge per cluster
}
\description{
Create groups of edges that are crossing the river in nearby locations,
using a density-based clustering method (DBSCAN). This is to make sure that
edges representing e.g. different lanes of the same street are treated as
part of the same crossing. For each cluster, select the shortest edge.
}
\keyword{internal}
