% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{pix.HPDataFrame}
\alias{pix.HPDataFrame}
\title{HEALPix pixel indices from \code{\link{HPDataFrame}}}
\usage{
\method{pix}{HPDataFrame}(x, new.pix, ...)
}
\arguments{
\item{x}{a \code{\link{HPDataFrame}}.}

\item{new.pix}{optional vector of pixel indices with
length equal to \code{nrow(x)}}

\item{...}{Unused arguments.}
}
\value{
The vector of HEALPix pixel indices (integers) or,
if new.pix is specified,
a new HPDataFrame.
}
\description{
If new.pix is unspecified then this function returns the vector of
HEALPix pixel indices from a HPDataFrame. If new.pix is specified then
this function returns a new HPDataFrame with the same number of rows
as \code{x}, but with pix attribute \code{new.pix}. Thus,
\code{new.pix} must have length equal to \code{nrow(x)}.
}
\examples{
df <- HPDataFrame(I = rep(0,12), nside = 1)
pix(df)

}
