% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_ds.R
\name{cp_ds}
\alias{cp_ds}
\title{Datasets API route catch all method}
\usage{
cp_ds(route, ..., .list = list())
}
\arguments{
\item{route}{(character) an API route. the \verb{/dataset} route
part is added internally; so just include the route following that.
required.}

\item{...}{named parameters, passed on to \code{\link[glue:glue]{glue::glue()}}. required.
param names must match must match names given in the \code{route}. For
example, if you have \verb{route = \\\\\{key\\\\\}/name\\\\\{id\\\\\}}, then you need
to pass in a \code{key} and an \code{id} parameter. The names in the route
(here, key and id) don't have to match the names in the API route you
are trying to use - they just need to match the named parameters you
pass in. Having said that, it may be easier to remember what you're
doing if you match the names to the route parts.}

\item{.list}{a named list. instead of passing in named parameters
through \code{...}, you can pre-prepare a named list and give to this
parameter}
}
\value{
output varies depending on the route requested, but output will
always be a named list. when no results found, an error message
will be returned
}
\description{
Datasets API route catch all method
}
\details{
There are A LOT of datasets API routes. Instead of making
an R function for each route, we have R functions for some of the
"more important" routes, then \code{cp_ds()} will allow you to make
requests to the remainder of the datasets API routes.
}
\section{Not supported dataset routes}{

Some dataset routes do not return JSON so we don't support those.
Thus far, the only route we don't support is \verb{/dataset/\\\\\{key\\\\\}/logo}
}

\examples{
\dontrun{
cp_ds(route = "{key}/tree", key = "1000")
cp_ds(route = "{key}/tree", key = "1014")
cp_ds(route = "{key}/name/{id}", key = 1005, id = 100003)

# pass a named list to the .list parameter
args <- list(key = 1005, id = 100003)
cp_ds("{key}/name/{id}", .list = args)
}
}
