% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climate_locations.R
\name{ec_climate_search_locations}
\alias{ec_climate_search_locations}
\alias{ec_climate_geosearch_locations}
\title{Search climate locations}
\usage{
ec_climate_search_locations(query = NULL, ..., timeframe = c("NA",
  "monthly", "daily", "hourly"), year = NULL, limit = NULL)

ec_climate_geosearch_locations(query = NULL, ..., timeframe = c("NA",
  "monthly", "daily", "hourly"), year = NULL, limit = NULL)
}
\arguments{
\item{query}{A query in several forms}

\item{...}{Additional arguments are used to \link[dplyr]{filter}
\link{ec_climate_locations_all}}

\item{timeframe}{The target timeframe for the query}

\item{year}{An optional year when the location must have data}

\item{limit}{The maximum number of locations to return (or NULL for no limit).
Lon/lat queries are automatically capped at 30 locations.}
}
\description{
Search climate locations
}
\examples{

# character searches match the location column of ec_climate_locations_all
# (case-insensitive)
ec_climate_search_locations("ottawa")

# multiple values use OR logic
ec_climate_search_locations(c("ottawa on", "halifax"))

# you can use a year and a timeframe to find locations that are known to have some
# data for that year/timeframe
ec_climate_search_locations("ottawa", year = 2016)
ec_climate_search_locations("ottawa", timeframe = "daily", year = 2016)

# you can also use a vector of years
ec_climate_search_locations("ottawa", timeframe = "daily", year = 2000:2016)

# if you need to search geographically, you can pass a numeric vector in the form
# c(lon, lat)
ec_climate_search_locations(c(-75.69031, 45.42111))

\donttest{
# to use a human readable geocoded location, use ec_climate_geosearch_locations()
ec_climate_geosearch_locations("ottawa on")
}

}
