/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.AllPairsShortestPaths;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smarts.SmartsPattern;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class XLogPDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private boolean salicylFlag = false;
    private static final String[] NAMES = new String[]{"XLogP"};
    public static final SmartsPattern C_TERMINAL_AMINO_ACID = SmartsPattern.create((String)"N!@C-C(=O)-[O;X2H1+0,X1H0-]");
    public static final SmartsPattern P_AMINO_SULPHONIC_ACID = SmartsPattern.create((String)"CS(=O)(=O)c1ccc(N)cc1");
    public static final SmartsPattern SALICYLIC_ACID_PTRN = SmartsPattern.create((String)"O=C(O)c1ccccc1O");
    public static final SmartsPattern ORTHOPAIR = SmartsPattern.create((String)"OccO");

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#xlogP", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 2) {
            throw new CDKException("XLogPDescriptor expects two parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        if (!(params[1] instanceof Boolean)) {
            throw new CDKException("The second parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
        this.salicylFlag = (Boolean)params[1];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity, this.salicylFlag};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
    }

    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtom atomi;
        int i;
        IAtomContainer ac;
        try {
            ac = atomContainer.clone();
            AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties((IAtomContainer)ac);
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)ac.getBuilder());
            hAdder.addImplicitHydrogens(ac);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)ac);
        }
        catch (CloneNotSupportedException | CDKException e) {
            return this.getDummyDescriptorValue((Exception)e);
        }
        IRingSet rs = Cycles.sssr((IAtomContainer)ac).toRingSet();
        if (this.checkAromaticity) {
            try {
                Aromaticity.cdkLegacy().apply(ac);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue((Exception)((Object)e));
            }
        }
        double xlogP = 0.0;
        String symbol = "";
        int atomCount = ac.getAtomCount();
        double xlogPOld = 0.0;
        ArrayList<Integer> hBondAcceptors = new ArrayList<Integer>();
        ArrayList<Integer> hBondDonors = new ArrayList<Integer>();
        int checkAminoAcid = 1;
        for (i = 0; i < atomCount; ++i) {
            atomi = ac.getAtom(i);
            IRingSet atomRingSet = rs.getRings(atomi);
            atomi.setProperty((Object)"IS_IN_AROMATIC_RING", (Object)false);
            atomi.setProperty((Object)"cdk:Part of ring of size", (Object)0);
            if (atomRingSet.getAtomContainerCount() <= 0) continue;
            if (atomRingSet.getAtomContainerCount() > 1) {
                Iterator containers = RingSetManipulator.getAllAtomContainers((IRingSet)atomRingSet).iterator();
                atomRingSet = (IRingSet)rs.getBuilder().newInstance(IRingSet.class, new Object[0]);
                while (containers.hasNext()) {
                    atomRingSet.add(Cycles.essential((IAtomContainer)((IAtomContainer)containers.next())).toRingSet());
                }
            }
            for (int j = 0; j < atomRingSet.getAtomContainerCount(); ++j) {
                if (j == 0) {
                    atomi.setProperty((Object)"cdk:Part of ring of size", (Object)((IRing)atomRingSet.getAtomContainer(j)).getRingSize());
                }
                if (!atomRingSet.getAtomContainer(j).contains(atomi)) continue;
                if (((IRing)atomRingSet.getAtomContainer(j)).getRingSize() >= 6 && atomi.getFlag(32)) {
                    atomi.setProperty((Object)"IS_IN_AROMATIC_RING", (Object)true);
                }
                if (((IRing)atomRingSet.getAtomContainer(j)).getRingSize() >= (Integer)atomi.getProperty((Object)"cdk:Part of ring of size")) continue;
                atomi.setProperty((Object)"cdk:Part of ring of size", (Object)((IRing)atomRingSet.getAtomContainer(j)).getRingSize());
            }
        }
        for (i = 0; i < atomCount; ++i) {
            int halcount;
            atomi = ac.getAtom(i);
            if (xlogPOld == xlogP & i > 0 & !symbol.equals("H")) {
                // empty if block
            }
            xlogPOld = xlogP;
            symbol = atomi.getSymbol();
            int bondCount = ac.getConnectedBondsCount(atomi);
            int hsCount = this.getHydrogenCount(ac, atomi);
            IBond.Order maxBondOrder = ac.getMaximumBondOrder(atomi);
            if (!symbol.equals("H")) {
                // empty if block
            }
            if (symbol.equals("C")) {
                if (bondCount == 2) {
                    if (hsCount >= 1) {
                        xlogP += 0.209;
                    } else if (maxBondOrder == IBond.Order.DOUBLE) {
                        xlogP += 2.073;
                    } else if (maxBondOrder == IBond.Order.TRIPLE) {
                        xlogP += 0.33;
                    }
                }
                if (bondCount == 3) {
                    if (((Boolean)atomi.getProperty((Object)"IS_IN_AROMATIC_RING")).booleanValue()) {
                        if (this.getAromaticCarbonsCount(ac, atomi) >= 2 && this.getAromaticNitrogensCount(ac, atomi) == 0) {
                            xlogP = hsCount == 0 ? (this.getAtomTypeXCount(ac, atomi) == 0 ? (xlogP += 0.296) : (xlogP -= 0.151)) : (xlogP += 0.337);
                        } else if (this.getAromaticNitrogensCount(ac, atomi) >= 1) {
                            if (hsCount == 0) {
                                xlogP = this.getAtomTypeXCount(ac, atomi) == 0 ? (xlogP += 0.174) : (xlogP += 0.366);
                            } else if (this.getHydrogenCount(ac, atomi) == 1) {
                                xlogP += 0.126;
                            }
                        }
                    } else {
                        if (hsCount == 0) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                xlogP = this.getPiSystemsCount(ac, atomi) <= 1 ? (xlogP += 0.05) : (xlogP += 0.013);
                            } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                                xlogP = this.getPiSystemsCount(ac, atomi) == 0 ? (xlogP -= 0.03) : (xlogP -= 0.027);
                            } else if (this.getAtomTypeXCount(ac, atomi) == 2) {
                                xlogP = this.getPiSystemsCount(ac, atomi) == 0 ? (xlogP += 0.005) : (xlogP -= 0.315);
                            }
                        }
                        if (hsCount == 1) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.466;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP += 0.136;
                                }
                            } else {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.001;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.31;
                                }
                            }
                        }
                        if (hsCount == 2) {
                            xlogP += 0.42;
                        }
                        if (this.getIfCarbonIsHydrophobic(ac, atomi)) {
                            xlogP += 0.211;
                        }
                    }
                }
                if (bondCount == 4) {
                    if (hsCount == 0) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP -= 0.006;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP -= 0.57;
                            }
                            if (this.getPiSystemsCount(ac, atomi) >= 2) {
                                xlogP -= 0.317;
                            }
                        } else {
                            xlogP = this.getPiSystemsCount(ac, atomi) == 0 ? (xlogP -= 0.316) : (xlogP -= 0.723);
                        }
                    }
                    if (hsCount == 1) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP += 0.127;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP -= 0.243;
                            }
                            if (this.getPiSystemsCount(ac, atomi) >= 2) {
                                xlogP -= 0.499;
                            }
                        } else {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP -= 0.205;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP -= 0.305;
                            }
                            if (this.getPiSystemsCount(ac, atomi) >= 2) {
                                xlogP -= 0.709;
                            }
                        }
                    }
                    if (hsCount == 2) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP += 0.358;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP -= 0.008;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 2) {
                                xlogP -= 0.185;
                            }
                        } else {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP -= 0.137;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP -= 0.303;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 2) {
                                xlogP -= 0.815;
                            }
                        }
                    }
                    if (hsCount > 2) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP += 0.528;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP += 0.267;
                            }
                        } else {
                            xlogP -= 0.032;
                        }
                    }
                    if (this.getIfCarbonIsHydrophobic(ac, atomi)) {
                        xlogP += 0.211;
                    }
                }
            }
            if (symbol.equals("N")) {
                if (ac.getBondOrderSum(atomi) >= 3.0 && this.getOxygenCount(ac, atomi) >= 2 && maxBondOrder == IBond.Order.DOUBLE) {
                    xlogP += 1.178;
                } else if (this.getPresenceOfCarbonil(ac, atomi) >= 1) {
                    if (hsCount == 0) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            xlogP += 0.078;
                        }
                        if (this.getAtomTypeXCount(ac, atomi) == 1) {
                            xlogP -= 0.118;
                        }
                    }
                    if (hsCount == 1) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            xlogP -= 0.096;
                            hBondDonors.add(i);
                        } else {
                            xlogP -= 0.044;
                            hBondDonors.add(i);
                        }
                    }
                    if (hsCount == 2) {
                        xlogP -= 0.646;
                        hBondDonors.add(i);
                    }
                } else if (bondCount == 1) {
                    if (this.getCarbonsCount(ac, atomi) == 1) {
                        xlogP -= 0.566;
                    }
                } else if (bondCount == 2) {
                    if (((Boolean)atomi.getProperty((Object)"IS_IN_AROMATIC_RING")).booleanValue()) {
                        xlogP -= 0.493;
                        if (checkAminoAcid != 0) {
                            ++checkAminoAcid;
                        }
                    } else if (this.getDoubleBondedCarbonsCount(ac, atomi) == 0) {
                        if (this.getDoubleBondedNitrogenCount(ac, atomi) == 0 && this.getDoubleBondedOxygenCount(ac, atomi) == 1) {
                            xlogP += 0.427;
                        }
                        if (this.getDoubleBondedNitrogenCount(ac, atomi) == 1) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                xlogP += 0.536;
                            }
                            if (this.getAtomTypeXCount(ac, atomi) == 1) {
                                xlogP -= 0.597;
                            }
                        }
                    } else if (this.getDoubleBondedCarbonsCount(ac, atomi) == 1) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP += 0.007;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP -= 0.275;
                            }
                        } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP += 0.366;
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP += 0.251;
                            }
                        }
                    }
                } else if (bondCount == 3) {
                    if (hsCount == 0) {
                        if (atomi.getFlag(32) || rs.contains(atomi) && (Integer)atomi.getProperty((Object)"cdk:Part of ring of size") > 3 && this.getPiSystemsCount(ac, atomi) >= 1) {
                            xlogP = this.getAtomTypeXCount(ac, atomi) == 0 ? (xlogP += 0.881) : (xlogP -= 0.01);
                        } else if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP += 0.159;
                            }
                            if (this.getPiSystemsCount(ac, atomi) > 0) {
                                xlogP += 0.761;
                            }
                        } else {
                            xlogP -= 0.239;
                        }
                    } else if (hsCount == 1) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (atomi.getFlag(32) || rs.contains(atomi) && (Integer)atomi.getProperty((Object)"cdk:Part of ring of size") > 3 && this.getPiSystemsCount(ac, atomi) >= 2) {
                                xlogP += 0.545;
                                hBondDonors.add(i);
                            } else {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP -= 0.112;
                                    hBondDonors.add(i);
                                }
                                if (this.getPiSystemsCount(ac, atomi) > 0) {
                                    xlogP += 0.166;
                                    hBondDonors.add(i);
                                }
                            }
                        } else if (rs.contains(atomi)) {
                            xlogP += 0.153;
                            hBondDonors.add(i);
                        } else {
                            xlogP += 0.324;
                            hBondDonors.add(i);
                        }
                    } else if (hsCount == 2) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP -= 0.534;
                                hBondDonors.add(i);
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP -= 0.329;
                                hBondDonors.add(i);
                            }
                            if (checkAminoAcid != 0) {
                                ++checkAminoAcid;
                            }
                        } else {
                            xlogP -= 1.082;
                            hBondDonors.add(i);
                        }
                    }
                }
            }
            if (symbol.equals("O")) {
                if (bondCount == 1 && maxBondOrder == IBond.Order.DOUBLE) {
                    xlogP -= 0.399;
                    if (!this.getPresenceOfHydroxy(ac, atomi)) {
                        hBondAcceptors.add(i);
                    }
                } else if (bondCount == 1 && hsCount == 0 && (this.getPresenceOfNitro(ac, atomi) || this.getPresenceOfCarbonil(ac, atomi) == 1) || this.getPresenceOfSulfat(ac, atomi)) {
                    xlogP -= 0.399;
                    if (!this.getPresenceOfHydroxy(ac, atomi)) {
                        hBondAcceptors.add(i);
                    }
                } else if (bondCount >= 1) {
                    if (hsCount == 0 && bondCount == 2) {
                        if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP += 0.084;
                            }
                            if (this.getPiSystemsCount(ac, atomi) > 0) {
                                xlogP += 0.435;
                            }
                        } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                            xlogP += 0.105;
                        }
                    } else if (this.getAtomTypeXCount(ac, atomi) == 0) {
                        if (this.getPiSystemsCount(ac, atomi) == 0) {
                            xlogP -= 0.467;
                            hBondDonors.add(i);
                            hBondAcceptors.add(i);
                        }
                        if (this.getPiSystemsCount(ac, atomi) == 1) {
                            xlogP += 0.082;
                            hBondDonors.add(i);
                            hBondAcceptors.add(i);
                        }
                    } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                        xlogP -= 0.522;
                        hBondDonors.add(i);
                        hBondAcceptors.add(i);
                    }
                }
            }
            if (symbol.equals("S")) {
                if (bondCount == 1 && maxBondOrder == IBond.Order.DOUBLE || bondCount == 1 && atomi.getFormalCharge() == -1) {
                    xlogP -= 0.148;
                } else if (bondCount == 2) {
                    xlogP = hsCount == 0 ? (xlogP += 0.255) : (xlogP += 0.419);
                } else if (bondCount == 3) {
                    if (this.getOxygenCount(ac, atomi) >= 1) {
                        xlogP -= 1.375;
                    }
                } else if (bondCount == 4 && this.getDoubleBondedOxygenCount(ac, atomi) >= 2) {
                    xlogP -= 0.168;
                }
            }
            if (symbol.equals("P")) {
                if (this.getDoubleBondedSulfurCount(ac, atomi) >= 1 && bondCount >= 4) {
                    xlogP += 1.253;
                } else if (this.getOxygenCount(ac, atomi) >= 1 || this.getDoubleBondedOxygenCount(ac, atomi) == 1 && bondCount >= 4) {
                    xlogP -= 0.447;
                }
            }
            if (symbol.equals("F")) {
                if (this.getPiSystemsCount(ac, atomi) == 0) {
                    xlogP += 0.375;
                } else if (this.getPiSystemsCount(ac, atomi) == 1) {
                    xlogP += 0.202;
                }
            }
            if (symbol.equals("Cl")) {
                if (this.getPiSystemsCount(ac, atomi) == 0) {
                    xlogP += 0.512;
                } else if (this.getPiSystemsCount(ac, atomi) >= 1) {
                    xlogP += 0.663;
                }
            }
            if (symbol.equals("Br")) {
                if (this.getPiSystemsCount(ac, atomi) == 0) {
                    xlogP += 0.85;
                } else if (this.getPiSystemsCount(ac, atomi) == 1) {
                    xlogP += 0.839;
                }
            }
            if (symbol.equals("I")) {
                if (this.getPiSystemsCount(ac, atomi) == 0) {
                    xlogP += 1.05;
                } else if (this.getPiSystemsCount(ac, atomi) == 1) {
                    xlogP += 1.109;
                }
            }
            if ((halcount = this.getHalogenCount(ac, atomi)) == 2) {
                xlogP += 0.137;
            } else if (halcount == 3) {
                xlogP += 0.41100000000000003;
            } else if (halcount == 4) {
                xlogP += 0.8220000000000001;
            }
            if (this.getPresenceOfCarbonil(ac, atomi) != 2 || rs.contains(atomi)) continue;
            xlogP += 0.58;
        }
        int[][] pairCheck = null;
        if (hBondAcceptors.size() > 0 && hBondDonors.size() > 0) {
            pairCheck = this.initializeHydrogenPairCheck(new int[atomCount][atomCount]);
        }
        AllPairsShortestPaths apsp = new AllPairsShortestPaths(ac);
        for (Integer hBondAcceptor : hBondAcceptors) {
            for (Integer hBondDonor : hBondDonors) {
                if (!this.checkRingLink(rs, ac, ac.getAtom(hBondAcceptor.intValue())) && !this.checkRingLink(rs, ac, ac.getAtom(hBondDonor.intValue()))) continue;
                int dist = apsp.from(ac.getAtom(hBondAcceptor.intValue())).distanceTo(ac.getAtom(hBondDonor.intValue()));
                if (this.checkRingLink(rs, ac, ac.getAtom(hBondAcceptor.intValue())) && this.checkRingLink(rs, ac, ac.getAtom(hBondDonor.intValue()))) {
                    if (dist != 3 || pairCheck[hBondAcceptor][hBondDonor] != 0) continue;
                    xlogP += 0.429;
                    pairCheck[hBondAcceptor.intValue()][hBondDonor.intValue()] = 1;
                    pairCheck[hBondDonor.intValue()][hBondAcceptor.intValue()] = 1;
                    continue;
                }
                if (dist != 4 || pairCheck[hBondAcceptor][hBondDonor] != 0) continue;
                xlogP += 0.429;
                pairCheck[hBondAcceptor.intValue()][hBondDonor.intValue()] = 1;
                pairCheck[hBondDonor.intValue()][hBondAcceptor.intValue()] = 1;
            }
        }
        if (C_TERMINAL_AMINO_ACID.matches(ac)) {
            xlogP -= 2.166;
        }
        if (P_AMINO_SULPHONIC_ACID.matches(ac)) {
            xlogP -= 0.501;
        }
        if (this.salicylFlag && SALICYLIC_ACID_PTRN.matches(ac)) {
            xlogP += 0.554;
        }
        if (ORTHOPAIR.matches(ac)) {
            xlogP -= 0.268;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(xlogP), this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    private int[][] initializeHydrogenPairCheck(int[][] pairCheck) {
        for (int i = 0; i < pairCheck.length; ++i) {
            for (int j = 0; j < pairCheck[0].length; ++j) {
                pairCheck[i][j] = 0;
            }
        }
        return pairCheck;
    }

    private boolean checkRingLink(IRingSet ringSet, IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        if (ringSet.contains(atom)) {
            return true;
        }
        for (IAtom neighbour : neighbours) {
            if (!ringSet.contains(neighbour)) continue;
            return true;
        }
        return false;
    }

    private int getHydrogenCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int hcounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 1) continue;
            ++hcounter;
        }
        return hcounter;
    }

    private int getHalogenCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int acounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 9 && neighbour.getAtomicNumber() != 53 && neighbour.getAtomicNumber() != 17 && neighbour.getAtomicNumber() != 35) continue;
            ++acounter;
        }
        return acounter;
    }

    private int getAtomTypeXCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int nocounter = 0;
        for (IAtom neighbour : neighbours) {
            IBond bond;
            if (neighbour.getAtomicNumber() != 7 && neighbour.getAtomicNumber() != 8 || ((Boolean)neighbour.getProperty((Object)"IS_IN_AROMATIC_RING")).booleanValue() || (bond = ac.getBond(neighbour, atom)).getOrder() == IBond.Order.DOUBLE) continue;
            ++nocounter;
        }
        return nocounter;
    }

    private int getAromaticCarbonsCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int carocounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 6 || !neighbour.getFlag(32)) continue;
            ++carocounter;
        }
        return carocounter;
    }

    private int getCarbonsCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int ccounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 6 || neighbour.getFlag(32)) continue;
            ++ccounter;
        }
        return ccounter;
    }

    private int getOxygenCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int ocounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 8 || neighbour.getFlag(32)) continue;
            ++ocounter;
        }
        return ocounter;
    }

    private int getDoubleBondedCarbonsCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int cdbcounter = 0;
        for (IAtom neighbour : neighbours) {
            IBond bond;
            if (neighbour.getAtomicNumber() != 6 || (bond = ac.getBond(neighbour, atom)).getOrder() != IBond.Order.DOUBLE) continue;
            ++cdbcounter;
        }
        return cdbcounter;
    }

    private int getDoubleBondedOxygenCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int odbcounter = 0;
        boolean chargeFlag = false;
        if (atom.getFormalCharge() >= 1) {
            chargeFlag = true;
        }
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 8) continue;
            IBond bond = ac.getBond(neighbour, atom);
            if (chargeFlag && neighbour.getFormalCharge() == -1 && bond.getOrder() == IBond.Order.SINGLE) {
                ++odbcounter;
            }
            if (neighbour.getFlag(32) || bond.getOrder() != IBond.Order.DOUBLE) continue;
            ++odbcounter;
        }
        return odbcounter;
    }

    private int getDoubleBondedSulfurCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int sdbcounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 16) continue;
            if (atom.getFormalCharge() == 1 && neighbour.getFormalCharge() == -1) {
                ++sdbcounter;
            }
            IBond bond = ac.getBond(neighbour, atom);
            if (neighbour.getFlag(32) || bond.getOrder() != IBond.Order.DOUBLE) continue;
            ++sdbcounter;
        }
        return sdbcounter;
    }

    private int getDoubleBondedNitrogenCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int ndbcounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 7) continue;
            IBond bond = ac.getBond(neighbour, atom);
            if (neighbour.getFlag(32) || bond.getOrder() != IBond.Order.DOUBLE) continue;
            ++ndbcounter;
        }
        return ndbcounter;
    }

    private int getAromaticNitrogensCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int narocounter = 0;
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 7 || !((Boolean)neighbour.getProperty((Object)"IS_IN_AROMATIC_RING")).booleanValue()) continue;
            ++narocounter;
        }
        return narocounter;
    }

    private int getPiSystemsCount(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int picounter = 0;
        for (Object value : neighbours) {
            IAtom neighbour = (IAtom)value;
            List bonds = ac.getConnectedBondsList(neighbour);
            for (Object o : bonds) {
                IBond bond = (IBond)o;
                if (bond.getOrder() == IBond.Order.SINGLE || bond.getOther(neighbour).equals((Object)atom) || neighbour.getAtomicNumber() == 15 || neighbour.getAtomicNumber() == 16) continue;
                ++picounter;
            }
        }
        return picounter;
    }

    private boolean getPresenceOfHydroxy(IAtomContainer ac, IAtom atom) {
        IAtom neighbour0 = (IAtom)ac.getConnectedAtomsList(atom).get(0);
        if (neighbour0.getAtomicNumber() == 6) {
            List first = ac.getConnectedAtomsList(neighbour0);
            for (Object o : first) {
                IAtom conAtom = (IAtom)o;
                if (conAtom.getAtomicNumber() != 8 || ac.getBond(neighbour0, conAtom).getOrder() != IBond.Order.SINGLE) continue;
                return ac.getConnectedBondsCount(conAtom) <= 1 || this.getHydrogenCount(ac, conAtom) != 0;
            }
        }
        return false;
    }

    private boolean getPresenceOfNitro(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        for (Object value : neighbours) {
            IAtom neighbour = (IAtom)value;
            if (neighbour.getAtomicNumber() != 7) continue;
            List second = ac.getConnectedAtomsList(neighbour);
            for (Object o : second) {
                IBond bond;
                IAtom conAtom = (IAtom)o;
                if (conAtom.getAtomicNumber() != 8 || (bond = ac.getBond(neighbour, conAtom)).getOrder() != IBond.Order.DOUBLE) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getPresenceOfSulfat(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        for (IAtom neighbour : neighbours) {
            if (neighbour.getAtomicNumber() != 16 || this.getOxygenCount(ac, neighbour) < 2 || ac.getConnectedBondsCount(neighbour) != 4) continue;
            return true;
        }
        return false;
    }

    private int getPresenceOfCarbonil(IAtomContainer ac, IAtom atom) {
        List neighbours = ac.getConnectedAtomsList(atom);
        int counter = 0;
        for (Object value : neighbours) {
            IAtom neighbour = (IAtom)value;
            if (neighbour.getAtomicNumber() != 6) continue;
            List second = ac.getConnectedAtomsList(neighbour);
            for (Object o : second) {
                IBond bond;
                IAtom conAtom = (IAtom)o;
                if (conAtom.getAtomicNumber() != 8 || (bond = ac.getBond(neighbour, conAtom)).getOrder() != IBond.Order.DOUBLE) continue;
                ++counter;
            }
        }
        return counter;
    }

    private boolean getIfCarbonIsHydrophobic(IAtomContainer ac, IAtom atom) {
        List first = ac.getConnectedAtomsList(atom);
        if (first.size() > 0) {
            for (Object item : first) {
                IAtom firstAtom = (IAtom)item;
                if (firstAtom.getAtomicNumber() != 6 && firstAtom.getAtomicNumber() != 1) {
                    return false;
                }
                List second = ac.getConnectedAtomsList(firstAtom);
                if (second.size() > 0) {
                    for (Object value : second) {
                        IAtom secondAtom = (IAtom)value;
                        if (secondAtom.getAtomicNumber() != 6 && secondAtom.getAtomicNumber() != 1) {
                            return false;
                        }
                        List third = ac.getConnectedAtomsList(secondAtom);
                        if (third.size() > 0) {
                            for (Object o : third) {
                                IAtom thirdAtom = (IAtom)o;
                                if (thirdAtom.getAtomicNumber() == 6 || thirdAtom.getAtomicNumber() == 1) continue;
                                return false;
                            }
                            continue;
                        }
                        return false;
                    }
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity", "salicylFlag"};
        return params;
    }

    public Object getParameterType(String name) {
        return true;
    }
}

