/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.charges.PiElectronegativity;
import org.openscience.cdk.graph.ShortestPaths;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.type.HyperconjugationReaction;
import org.openscience.cdk.tools.StructureResonanceGenerator;

public class StabilizationCharges {
    public double calculatePositive(IAtomContainer atomContainer, IAtom atom) {
        if (atom.getFormalCharge() != 1) {
            return 0.0;
        }
        StructureResonanceGenerator gRI = new StructureResonanceGenerator();
        List<IReactionProcess> reactionList = gRI.getReactions();
        reactionList.add(new HyperconjugationReaction());
        gRI.setReactions(reactionList);
        IAtomContainerSet resonanceS = gRI.getStructures(atomContainer);
        IAtomContainerSet containerS = gRI.getContainers(atomContainer);
        if (resonanceS.getAtomContainerCount() < 2) {
            return 0.0;
        }
        int positionStart = atomContainer.indexOf(atom);
        ArrayList<Double> result1 = new ArrayList<Double>();
        ArrayList<Integer> distance1 = new ArrayList<Integer>();
        resonanceS.removeAtomContainer(0);
        for (IAtomContainer resonance : resonanceS.atomContainers()) {
            if (resonance.getAtomCount() < 2) continue;
            ShortestPaths shortestPaths = new ShortestPaths(resonance, resonance.getAtom(positionStart));
            PiElectronegativity electronegativity = new PiElectronegativity();
            for (IAtom atomP : resonance.atoms()) {
                IAtom atomR = atomContainer.getAtom(resonance.indexOf(atomP));
                if (!containerS.getAtomContainer(0).contains(atomR)) continue;
                electronegativity.setMaxIterations(6);
                double result = electronegativity.calculatePiElectronegativity(resonance, atomP);
                result1.add(result);
                int dis = shortestPaths.distanceTo(atomP);
                distance1.add(dis);
            }
        }
        double value = 0.0;
        double sum = 0.0;
        Iterator itDist = distance1.iterator();
        Iterator itElec = result1.iterator();
        while (itElec.hasNext()) {
            double suM = (Double)itElec.next();
            if (suM < 0.0) {
                suM = -1.0 * suM;
            }
            sum += suM * Math.pow(0.67, ((Integer)itDist.next()).intValue());
        }
        value = sum;
        return value;
    }
}

