/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.IChargeCalculator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.charges.GasteigerMarsiliPartialChargesTest")
public class GasteigerMarsiliPartialCharges
implements IChargeCalculator {
    private double DEOC_HYDROGEN = 20.02;
    private double MX_DAMP = 0.5;
    private double MX_ITERATIONS = 20.0;
    private int STEP_SIZE = 5;

    @TestMethod(value="testSetChiCatHydrogen_Double")
    public void setChiCatHydrogen(double chiCat) {
        this.DEOC_HYDROGEN = chiCat;
    }

    @TestMethod(value="testSetMaxGasteigerDamp_Double")
    public void setMaxGasteigerDamp(double damp) {
        this.MX_DAMP = damp;
    }

    @TestMethod(value="testSetMaxGasteigerIters_Double")
    public void setMaxGasteigerIters(double iters) {
        this.MX_ITERATIONS = iters;
    }

    @TestMethod(value="testGetChiCatHydrogen")
    public double getChiCatHydrogen() {
        return this.DEOC_HYDROGEN;
    }

    @TestMethod(value="testGetMaxGasteigerDamp")
    public double getMaxGasteigerDamp() {
        return this.MX_DAMP;
    }

    @TestMethod(value="testGetMaxGasteigerIters")
    public double getMaxGasteigerIters() {
        return this.MX_ITERATIONS;
    }

    @TestMethod(value="testAssignGasteigerMarsiliSigmaPartialCharges_IAtomContainer_Boolean")
    public IAtomContainer assignGasteigerMarsiliSigmaPartialCharges(IAtomContainer ac, boolean setCharge) throws Exception {
        int i;
        for (int i2 = 0; i2 < ac.getAtomCount(); ++i2) {
            ac.getAtom(i2).setCharge(Double.valueOf(0.0));
        }
        double[] gasteigerFactors = this.assignGasteigerSigmaMarsiliFactors(ac);
        double alpha = 1.0;
        Object atoms = null;
        int atom1 = 0;
        int atom2 = 0;
        double[] q_old = new double[ac.getAtomCount()];
        for (i = 0; i < q_old.length; ++i) {
            q_old[0] = 20.0;
        }
        i = 0;
        while ((double)i < this.MX_ITERATIONS) {
            double q;
            alpha *= this.MX_DAMP;
            boolean isDifferent = false;
            for (int j = 0; j < ac.getAtomCount(); ++j) {
                q = gasteigerFactors[this.STEP_SIZE * j + j + 5];
                double difference = Math.abs(q_old[j]) - Math.abs(q);
                if (Math.abs(difference) > 0.001) {
                    isDifferent = true;
                }
                q_old[j] = q;
                gasteigerFactors[this.STEP_SIZE * j + j + 4] = gasteigerFactors[this.STEP_SIZE * j + j + 2] * q * q + gasteigerFactors[this.STEP_SIZE * j + j + 1] * q + gasteigerFactors[this.STEP_SIZE * j + j];
            }
            if (!isDifferent) break;
            for (IBond bond : ac.bonds()) {
                atom1 = ac.getAtomNumber(bond.getAtom(0));
                double deoc = gasteigerFactors[this.STEP_SIZE * atom1 + atom1 + 4] >= gasteigerFactors[this.STEP_SIZE * (atom2 = ac.getAtomNumber(bond.getAtom(1))) + atom2 + 4] ? (ac.getAtom(atom2).getSymbol().equals("H") ? this.DEOC_HYDROGEN : gasteigerFactors[this.STEP_SIZE * atom2 + atom2 + 3]) : (ac.getAtom(atom1).getSymbol().equals("H") ? this.DEOC_HYDROGEN : gasteigerFactors[this.STEP_SIZE * atom1 + atom1 + 3]);
                q = (gasteigerFactors[this.STEP_SIZE * atom1 + atom1 + 4] - gasteigerFactors[this.STEP_SIZE * atom2 + atom2 + 4]) / deoc;
                int n = this.STEP_SIZE * atom1 + atom1 + 5;
                gasteigerFactors[n] = gasteigerFactors[n] - q * alpha;
                int n2 = this.STEP_SIZE * atom2 + atom2 + 5;
                gasteigerFactors[n2] = gasteigerFactors[n2] + q * alpha;
            }
            ++i;
        }
        for (i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setCharge(Double.valueOf(gasteigerFactors[this.STEP_SIZE * i + i + 5]));
        }
        return ac;
    }

    @Override
    @TestMethod(value="testCalculateCharges_IAtomContainer")
    public void calculateCharges(IAtomContainer container) throws CDKException {
        try {
            this.assignGasteigerMarsiliSigmaPartialCharges(container, true);
        }
        catch (Exception exception) {
            throw new CDKException("Could not calculate Gasteiger-Marsili sigma charges: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @TestMethod(value="testGetStepSize")
    public int getStepSize() {
        return this.STEP_SIZE;
    }

    @TestMethod(value="testSetStepSize")
    public void setStepSize(int step) {
        this.STEP_SIZE = step;
    }

    @TestMethod(value="testAssignGasteigerSigmaMarsiliFactors_IAtomContainer")
    public double[] assignGasteigerSigmaMarsiliFactors(IAtomContainer ac) throws CDKException {
        double[] gasteigerFactors = new double[ac.getAtomCount() * (this.STEP_SIZE + 1)];
        String AtomSymbol = "";
        double[] factors = new double[]{0.0, 0.0, 0.0};
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            factors[0] = 0.0;
            factors[1] = 0.0;
            factors[2] = 0.0;
            AtomSymbol = ac.getAtom(i).getSymbol();
            if (AtomSymbol.equals("H")) {
                factors[0] = 7.17;
                factors[1] = 6.24;
                factors[2] = -0.56;
            } else if (AtomSymbol.equals("C")) {
                if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE && ac.getAtom(i).getFormalCharge() != -1) {
                    factors[0] = 7.98;
                    factors[1] = 9.18;
                    factors[2] = 1.88;
                } else if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.DOUBLE || ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE && ac.getAtom(i).getFormalCharge() == -1) {
                    factors[0] = 8.79;
                    factors[1] = 9.32;
                    factors[2] = 1.51;
                } else if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.TRIPLE || ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.QUADRUPLE) {
                    factors[0] = 10.39;
                    factors[1] = 9.45;
                    factors[2] = 0.73;
                }
            } else if (AtomSymbol.equals("N")) {
                if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE && ac.getAtom(i).getFormalCharge() != -1) {
                    factors[0] = 11.54;
                    factors[1] = 10.82;
                    factors[2] = 1.36;
                } else if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.DOUBLE || ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE && ac.getAtom(i).getFormalCharge() == -1) {
                    factors[0] = 12.87;
                    factors[1] = 11.15;
                    factors[2] = 0.85;
                } else if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.TRIPLE || ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.QUADRUPLE) {
                    factors[0] = 17.68;
                    factors[1] = 12.7;
                    factors[2] = -0.27;
                }
            } else if (AtomSymbol.equals("O")) {
                if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE && ac.getAtom(i).getFormalCharge() != -1) {
                    factors[0] = 14.18;
                    factors[1] = 12.92;
                    factors[2] = 1.39;
                } else if (ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.DOUBLE || ac.getMaximumBondOrder(ac.getAtom(i)) == IBond.Order.SINGLE && ac.getAtom(i).getFormalCharge() == -1) {
                    factors[0] = 17.07;
                    factors[1] = 13.79;
                    factors[2] = 0.47;
                }
            } else if (AtomSymbol.equals("Si")) {
                factors[0] = 8.1;
                factors[1] = 7.92;
                factors[2] = 1.78;
            } else if (AtomSymbol.equals("P")) {
                factors[0] = 8.9;
                factors[1] = 8.32;
                factors[2] = 1.58;
            } else if (AtomSymbol.equals("S")) {
                factors[0] = 10.14;
                factors[1] = 9.13;
                factors[2] = 1.38;
            } else if (AtomSymbol.equals("F")) {
                factors[0] = 14.66;
                factors[1] = 13.85;
                factors[2] = 2.31;
            } else if (AtomSymbol.equals("Cl")) {
                factors[0] = 12.31;
                factors[1] = 10.84;
                factors[2] = 1.512;
            } else if (AtomSymbol.equals("Br")) {
                factors[0] = 11.44;
                factors[1] = 9.63;
                factors[2] = 1.31;
            } else if (AtomSymbol.equals("I")) {
                factors[0] = 9.88;
                factors[1] = 7.95;
                factors[2] = 0.945;
            } else {
                throw new CDKException("Partial charge not-supported for element: '" + AtomSymbol + "'.");
            }
            gasteigerFactors[this.STEP_SIZE * i + i] = factors[0];
            gasteigerFactors[this.STEP_SIZE * i + i + 1] = factors[1];
            gasteigerFactors[this.STEP_SIZE * i + i + 2] = factors[2];
            gasteigerFactors[this.STEP_SIZE * i + i + 5] = ac.getAtom(i).getCharge();
            gasteigerFactors[this.STEP_SIZE * i + i + 3] = factors[0] == 0.0 && factors[1] == 0.0 && factors[2] == 0.0 ? 1.0 : factors[0] + factors[1] + factors[2];
        }
        return gasteigerFactors;
    }
}

