/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class RDBERule
implements IRule {
    private static Map<String, int[]> oxidationStateTable = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RDBERule.class);
    private double min = -0.5;
    private double max = 30.0;

    public RDBERule() {
        this.createTable();
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 2) {
            throw new CDKException("RDBERule expects two parameters");
        }
        if (!(params[0] instanceof Double)) {
            throw new CDKException("The 1 parameter must be of type Double");
        }
        if (!(params[1] instanceof Double)) {
            throw new CDKException("The 2 parameter must be of type Double");
        }
        this.min = (Double)params[0];
        this.max = (Double)params[1];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.min, this.max};
        return params;
    }

    @Override
    public double validate(IMolecularFormula formula) throws CDKException {
        logger.info((Object)"Start validation of ", new Object[]{formula});
        List<Double> RDBEList = this.getRDBEValue(formula);
        for (double RDBE : RDBEList) {
            if (!(this.min <= RDBE) || !(RDBE <= 30.0) || !this.validate(formula, RDBE)) continue;
            return 1.0;
        }
        return 0.0;
    }

    public boolean validate(IMolecularFormula formula, double value) throws CDKException {
        long iPart;
        double fPart;
        double charge = 0.0;
        if (formula.getCharge() != CDKConstants.UNSET) {
            charge = formula.getCharge().intValue();
        }
        if ((fPart = value - (double)(iPart = (long)value)) == 0.0 && charge == 0.0) {
            return true;
        }
        return fPart != 0.0 && charge != 0.0;
    }

    public List<Double> getRDBEValue(IMolecularFormula formula) {
        ArrayList<Double> RDBEList = new ArrayList<Double>();
        int nE = 0;
        ArrayList<Integer> nV = new ArrayList<Integer>();
        for (IIsotope isotope : formula.isotopes()) {
            int[] valence = this.getOxidationState((IAtom)formula.getBuilder().newInstance(IAtom.class, new Object[]{isotope.getSymbol()}));
            if (valence.length == 1) continue;
            for (int i = 0; i < valence.length; ++i) {
                nV.add(valence[i]);
            }
            nE += MolecularFormulaManipulator.getElementCount(formula, (IElement)formula.getBuilder().newInstance(IElement.class, new Object[]{isotope.getSymbol()}));
        }
        double RDBE = 0.0;
        if (nE == 0) {
            for (IIsotope isotope : formula.isotopes()) {
                int[] valence = this.getOxidationState((IAtom)formula.getBuilder().newInstance(IAtom.class, new Object[]{isotope.getSymbol()}));
                double value = (double)((valence[0] - 2) * formula.getIsotopeCount(isotope)) / 2.0;
                RDBE += value;
            }
            RDBEList.add(RDBE += 1.0);
        } else {
            double RDBE_1 = 0.0;
            for (IIsotope isotope : formula.isotopes()) {
                int[] valence = this.getOxidationState((IAtom)formula.getBuilder().newInstance(IAtom.class, new Object[]{isotope.getSymbol()}));
                double value = (double)((valence[0] - 2) * formula.getIsotopeCount(isotope)) * 0.5;
                RDBE_1 += value;
            }
            Object[] valences = new String[nV.size()];
            for (int i = 0; i < valences.length; ++i) {
                valences[i] = Integer.toString((Integer)nV.get(i));
            }
            Combinations c = new Combinations(valences, nE);
            while (c.hasMoreElements()) {
                double RDBE_int = 0.0;
                Object[] combo = (Object[])c.nextElement();
                for (int i = 0; i < combo.length; ++i) {
                    int value = (Integer.parseInt((String)combo[i]) - 2) / 2;
                    RDBE_int += (double)value;
                }
                RDBE = 1.0 + RDBE_1 + RDBE_int;
                RDBEList.add(RDBE);
            }
        }
        return RDBEList;
    }

    private int[] getOxidationState(IAtom newAtom) {
        return oxidationStateTable.get(newAtom.getSymbol());
    }

    private void createTable() {
        if (oxidationStateTable == null) {
            oxidationStateTable = new HashMap<String, int[]>();
            oxidationStateTable.put("H", new int[]{1});
            oxidationStateTable.put("B", new int[]{3});
            oxidationStateTable.put("C", new int[]{4});
            oxidationStateTable.put("N", new int[]{3});
            oxidationStateTable.put("O", new int[]{2});
            oxidationStateTable.put("F", new int[]{1});
            oxidationStateTable.put("Na", new int[]{1});
            oxidationStateTable.put("Mg", new int[]{2});
            oxidationStateTable.put("Al", new int[]{3});
            oxidationStateTable.put("Si", new int[]{4});
            oxidationStateTable.put("P", new int[]{3, 5});
            oxidationStateTable.put("S", new int[]{2, 4, 6});
            oxidationStateTable.put("Cl", new int[]{1});
            oxidationStateTable.put("I", new int[]{1});
        }
    }

    public class Combinations {
        private Object[] inArray;
        private int n;
        private int m;
        private int[] index;
        private boolean hasMore = true;

        public Combinations(Object[] inArray, int m) {
            this.inArray = inArray;
            this.n = inArray.length;
            this.m = m;
            this.index = new int[m];
            for (int i = 0; i < m; ++i) {
                this.index[0] = 0;
            }
        }

        public boolean hasMoreElements() {
            return this.hasMore;
        }

        private void moveIndex() {
            int i = this.rightmostIndexBelowMax();
            if (i >= 0) {
                this.index[i] = this.index[i] + 1;
                for (int j = i + 1; j < this.m; ++j) {
                    this.index[j] = this.index[j - 1];
                }
            } else {
                this.hasMore = false;
            }
        }

        public Object nextElement() {
            if (!this.hasMore) {
                return null;
            }
            Object[] out = new Object[this.m];
            for (int i = 0; i < this.m; ++i) {
                out[i] = this.inArray[this.index[i]];
            }
            this.moveIndex();
            return out;
        }

        private int rightmostIndexBelowMax() {
            for (int i = this.m - 1; i >= 0; --i) {
                int s = this.n - 1;
                if (this.index[i] == s) continue;
                return i;
            }
            return -1;
        }
    }
}

