/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.protein.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openscience.cdk.BioPolymer;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IPDBStructure;
import org.openscience.cdk.interfaces.IStrand;

public class PDBPolymer
extends BioPolymer
implements Cloneable,
IPDBPolymer {
    private static final long serialVersionUID = 4173552834313952358L;
    List<String> sequentialListOfMonomers = new ArrayList<String>();
    List<IPDBStructure> secondaryStructures = new ArrayList<IPDBStructure>();

    public void addStructure(IPDBStructure structure) {
        this.secondaryStructures.add(structure);
    }

    public Collection<IPDBStructure> getStructures() {
        return new ArrayList<IPDBStructure>(this.secondaryStructures);
    }

    public void addAtom(IPDBAtom oAtom) {
        super.addAtom((IAtom)oAtom);
    }

    public void addAtom(IPDBAtom oAtom, IMonomer oMonomer) {
        super.addAtom((IAtom)oAtom, oMonomer);
        if (!this.sequentialListOfMonomers.contains(oMonomer.getMonomerName())) {
            this.sequentialListOfMonomers.add(oMonomer.getMonomerName());
        }
    }

    public void addAtom(IPDBAtom oAtom, IMonomer oMonomer, IStrand oStrand) {
        super.addAtom((IAtom)oAtom, oMonomer, oStrand);
        if (!this.sequentialListOfMonomers.contains(oMonomer.getMonomerName())) {
            this.sequentialListOfMonomers.add(oMonomer.getMonomerName());
        }
    }

    public Collection<String> getMonomerNamesInSequentialOrder() {
        return new ArrayList<String>(this.sequentialListOfMonomers);
    }

    public IPDBPolymer clone() throws CloneNotSupportedException {
        return (IPDBPolymer)super.clone();
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("PDBPolymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(")");
        return stringContent.toString();
    }
}

