/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ZMatrixTools {
    public static Point3d[] zmatrixToCartesian(double[] distances, int[] first_atoms, double[] angles, int[] second_atoms, double[] dihedrals, int[] third_atoms) {
        Point3d[] cartesianCoords = new Point3d[distances.length];
        for (int index = 0; index < distances.length; ++index) {
            if (index == 0) {
                cartesianCoords[index] = new Point3d(0.0, 0.0, 0.0);
                continue;
            }
            if (index == 1) {
                cartesianCoords[index] = new Point3d(distances[1], 0.0, 0.0);
                continue;
            }
            if (index == 2) {
                cartesianCoords[index] = new Point3d(-Math.cos(angles[2] / 180.0 * Math.PI) * distances[2] + distances[1], Math.sin(angles[2] / 180.0 * Math.PI) * distances[2], 0.0);
                if (first_atoms[index] != 0) continue;
                cartesianCoords[index].x = (cartesianCoords[index].x - distances[1]) * -1.0;
                continue;
            }
            Vector3d cd = new Vector3d();
            cd.sub((Tuple3d)cartesianCoords[third_atoms[index]], (Tuple3d)cartesianCoords[second_atoms[index]]);
            Vector3d bc = new Vector3d();
            bc.sub((Tuple3d)cartesianCoords[second_atoms[index]], (Tuple3d)cartesianCoords[first_atoms[index]]);
            Vector3d n1 = new Vector3d();
            n1.cross(cd, bc);
            Vector3d n2 = ZMatrixTools.rotate(n1, bc, -dihedrals[index]);
            Vector3d ba = ZMatrixTools.rotate(bc, n2, -angles[index]);
            ba.normalize();
            ba.scale(distances[index]);
            Point3d result = new Point3d();
            result.add((Tuple3d)cartesianCoords[first_atoms[index]], (Tuple3d)ba);
            cartesianCoords[index] = result;
        }
        return cartesianCoords;
    }

    private static Vector3d rotate(Vector3d vector, Vector3d axis, double angle) {
        Matrix3d rotate = new Matrix3d();
        rotate.set(new AxisAngle4d(axis, Math.toRadians(angle)));
        Vector3d result = new Vector3d();
        rotate.transform((Tuple3d)vector, (Tuple3d)result);
        return result;
    }
}

